% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical.R
\name{h_get_empirical}
\alias{h_get_empirical}
\title{Obtain Empirical/Jackknife/Bias-Reduced Covariance}
\usage{
h_get_empirical(tmb_data, theta, beta, beta_vcov, type)
}
\arguments{
\item{tmb_data}{(\code{mmrm_tmb_data})\cr produced by \code{\link[=h_mmrm_tmb_data]{h_mmrm_tmb_data()}}.}

\item{theta}{(\code{numeric})\cr theta estimate.}

\item{beta}{(\code{numeric})\cr beta estimate.}

\item{beta_vcov}{(\code{matrix})\cr covariance of beta estimate.}

\item{type}{(\code{string})\cr type of empirical method, including "Empirical", "Empirical-Jackknife"
and "Empirical-Bias-Reduced".}
}
\value{
Named list with elements:
\itemize{
\item \code{cov}: \code{matrix} empirical covariance.
\item \code{df_mat}: \code{matrix} to calculate Satterthwaite degree of freedom.
}
}
\description{
Obtain the empirical or Jackknife covariance for \eqn{\beta}.
Used in \code{mmrm} fitting if method is "Empirical", "Empirical-Jackknife" or
"Empirical-Bias-Reduced".
}
\keyword{internal}
