% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_lords_type.R
\name{mnis_lords_type}
\alias{mnis_lords_type}
\title{Peers' party affiliations}
\usage{
mnis_lords_type(date = Sys.Date(), tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{date}{Accepts character values in \code{'YYYY-MM-DD'} format,
and objects of class \code{Date}, \code{POSIXt}, \code{POSIXct},
\code{POSIXlt} or anything else than can be coerced to a date with
\code{as.Date()}. The API will return data on the composition of the
House of Lords on that date. Defaults to the current system date.}

\item{tidy}{If \code{TRUE}, fixes the variable names in the tibble to
remove non-alphanumeric characters and superfluous text, and convert to
a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy=TRUE}. Accepts one of \code{"snake_case"}, \code{"camelCase"} and
\code{"period.case"}. Defaults to \code{"snake_case"}.}
}
\value{
A tibble with information on the numbers of different types
of Lords on a given date.
}
\description{
Calls the API to return a tibble with details on the number of Lords
and their party affiliations. Defaults to the current date, but can
also return the number of Lords and their affiliations on a given date.
}
\examples{
\dontrun{
x <- mnis_lords_type()
}

}
