% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{mm_ArrayData}
\alias{mm_ArrayData}
\title{Array Data}
\usage{
mm_ArrayData(
  IDs,
  DAYS,
  VALUE,
  MID = NULL,
  targetLENGTH,
  targetMID = NULL,
  transformation = c("minmax", "geom", "zscore", "log", "log10"),
  impute_missing = 3
)
}
\arguments{
\item{IDs}{A vector that contains individual IDs repeated for multiple days of collection.}

\item{DAYS}{A vector that contains information on time, IE Day 1, Day 2, Day 3. Note: this vector should include integers, continuous data might produce unintended results.}

\item{VALUE}{A vector containing the variable sampled.}

\item{MID}{Am optional vector of midpoints to center each individuals profile. These should be unique to each individual and repeated for each observation of DAYS, VALUE, and IDs. If NULL (defualt), data will not be centered on any day.}

\item{targetLENGTH}{Integer. Number of days to up/down sample observations to using \code{\link{mm_get_interval}}.}

\item{targetMID}{If NULL (default) data will not be centered and will range from 0 to 1. If specified, data will be centered on 0 ranging from -1 to 1.}

\item{transformation}{Which (if any) data transformation to apply. Our reccomendation is minmax, but Geometric mean, Zscore, natural log and log10 transformations are available, if desired.}

\item{impute_missing}{Integer. If not null, number of nearest-neighbors to use to impute missing data (Default = 3).}
}
\value{
Returns a 3D array of data to be analyzed with individuals in the 3rd dimension.
}
\description{
Construct a ragged array (containing missing data) of a specified length (up/down sampling individuals to fit).
}
