% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_woe.R
\name{cal_woe}
\alias{cal_woe}
\title{Perform WoE transformation of a numeric variable}
\usage{
cal_woe(x, bin)
}
\arguments{
\item{x}{A numeric vector that will be transformed to WoE values.}

\item{bin}{A list with the binning outcome from the binning function, 
e.g. qtl_bin() or iso_bin()}
}
\value{
A numeric vector with WoE transformed values.
}
\description{
The function \code{cal_woe} applies the WoE transformation to a numeric 
vector based on the binning outcome from a binning function, e.g. qtl_bin()
or iso_bin().
}
\examples{
data(hmeq)
bin_out <- qtl_bin(hmeq$DEROG, hmeq$BAD)
cal_woe(hmeq$DEROG[1:10], bin_out)
}
