% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock.R
\name{with_mock}
\alias{with_mock}
\alias{local_mock}
\alias{mock}
\alias{mock_call}
\alias{mock_args}
\alias{mock_n_called}
\title{Mock functions in a package.}
\usage{
with_mock(..., mock_env = pkg_env(), eval_env = parent.frame())

local_mock(
  ...,
  mock_env = pkg_env(),
  eval_env = parent.frame(),
  local_env = eval_env
)

mock(expr, env = parent.frame())

mock_call(x, call_no = mock_n_called(x))

mock_args(x, arg = NULL, call_no = mock_n_called(x))

mock_n_called(x)
}
\arguments{
\item{...}{Named parameters redefine mocked functions, unnamed parameters
will be evaluated after mocking the functions.}

\item{mock_env}{The environment in which to patch the functions,
defaults to the top-level environment. A string is interpreted as package
name.}

\item{eval_env}{Environment in which expressions passed as \code{...} are
evaluated, defaults to \code{\link[=parent.frame]{parent.frame()}}.}

\item{local_env}{Passed to \code{\link[withr:defer]{withr::defer()}} as \code{envir} argument}

\item{expr}{Expression to be used as body of the function to be mocked.}

\item{env}{Environment used as ancestor to the mock function environment.}

\item{x}{Object of class \code{mock_fun} to be queried for call and argument
information.}

\item{call_no}{The call number of interest (in case the function was called
multiple times).}

\item{arg}{String-valued argument name to be retrieved.}
}
\value{
The result of the last unnamed argument passed as \code{...} (evaluated
in the environment passed as \code{eval_env}) in the case of \code{local_mock()} and
a list of functions or \code{mock_fun} objects (invisibly) in the case of
\code{local_mock()}.
}
\description{
Mocking allows you to temporary replace the implementation of functions
within a package, which useful for testing code that relies on functions
that are slow, have unintended side effects or access resources that may
not be available when testing.

Up until recently, such capability was offered via \code{\link[testthat:with_mock]{testthat::with_mock()}},
but with release of version 3.0.0 and introduction of edition 3, this was
deprecated from testthat, leaving it to third party packages to replace this
feature. This mocking implementation is powered by
\code{\link[utils:getFromNamespace]{utils::assignInNamespace()}} and therefore, caveats outlined in the
corresponding documentation apply here too.
}
\examples{

url <- "https://eu.httpbin.org/get?foo=123"
mok <- function(...) "mocked request"

with_mock(
  `curl::curl_fetch_memory` = mok,
  curl::curl_fetch_memory(url)
)

dl_fun <- function(x) curl::curl_fetch_memory(x)

with_mock(
  `curl::curl_fetch_memory` = mok,
  dl_fun(url)
)

json <- function(...) '["mocked request"]'

with_mock(
  `curl::curl` = json,
  jsonlite::fromJSON(url)
)

with_mock(
  `curl::curl` = '["mocked request"]',
  jsonlite::fromJSON(url)
)

with_mock(
  `curl::curl` = quote({
    x <- "mocked request"
    paste0('["', x, '"]')
  }),
  jsonlite::fromJSON(url)
)

with_mock(
  `curl::curl` = json,
  parse_and_simplify = function(txt, ...) gsub('\\\\[?\\\\"\\\\]?', "", txt),
  jsonlite::fromJSON(url),
  mock_env = "jsonlite"
)

mk <- mock("mocked request")
dl <- function(x) curl::curl(x)

with_mock(`curl::curl` = mk, dl(url))

mock_call(mk)
mock_args(mk)

mk <- local_mock(`curl::curl` = "mocked request")
dl(url)

mock_args(mk, "url")

}
