% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{COVID19_JanApr2020_HongKong}
\alias{COVID19_JanApr2020_HongKong}
\title{A dataset of COVID-19 outbreak in Hong Kong}
\format{
A data frame (\code{data.frame}) with 290 rows of records, and 2 columns of variables:
\describe{
\item{\code{obs}}{Observations of offspring (or secondary) case numbers generated by each seed case.}
\item{\code{type}}{A categorical variable takes the value "secondary" indicating the type of observations.}
}
}
\source{
Summary of data and outbreak situation of the Severe Respiratory Disease associated with a Novel Infectious Agent,
released by the Centre for Health Protection, Department of Health, the Government of the Hong Kong Special Administrative Region.
See for example, \url{https://www.coronavirus.gov.hk/eng/index.html}
}
\usage{
COVID19_JanApr2020_HongKong
}
\description{
This dataset (i.e., \code{COVID19_JanApr2020_HongKong}) contains 290 observations of \strong{offspring case number} generated by one seed case,
which were collected during the coronavirus disease 2019 (COVID-19) outbreak in Hong Kong, China from January to April 2020.
}
\examples{
data(COVID19_JanApr2020_HongKong)
summary(COVID19_JanApr2020_HongKong)
table(COVID19_JanApr2020_HongKong$obs)

}
\references{
Adam DC, Wu P, Wong JY, Lau EH, Tsang TK, Cauchemez S, Leung GM, Cowling BJ. Clustering and superspreading potential of SARS-CoV-2 infections in Hong Kong. \emph{Nature Medicine}. 2020;26(11):1714-1719.
\doi{10.1038/s41591-020-1092-0}
}
\keyword{datasets}
