% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elevators.R
\name{data_elevators}
\alias{data_elevators}
\title{elevators data set}
\source{
\url{https://github.com/datanews/elevators}
}
\usage{
data_elevators(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[pins:pin_read]{pins::pin_read()}}.}
}
\value{
tibble
}
\description{
A data set containing information of a subset of the elevators in NYC. The
data set has been filtered to contain active elevators with non-missing
speed.
}
\details{
\describe{
\item{device_number}{Unique identify number for the elevator}
\item{bin}{Building Identification Number}
\item{borough}{Regional subdivisions of NYC. One of "Manhattan", "Bronx",
"Brooklyn", "Queens", or "Staten Island"}
\item{tax_block}{Id for tax block. Smaller than borough}
\item{tax_lot}{Id for tax block. Smaller than tax_block}
\item{house_number}{House number, very poorly parsed. Use with caution}
\item{street_name}{Street name, very poorly parsed. Use with caution}
\item{zip_code}{Zip code, formatted to 5 digits. 0 and 99999 are marked as
NA}
\item{device_type}{Type of device. Most common type is "Passenger Elevator"}
\item{lastper_insp_date}{Date, refers to the last periodic inspection by
the Department of Buildings. These dates will no longer be accurate, as
they were collected by November 2015}
\item{approval_date}{Date of approval for elevator}
\item{manufacturer}{Name of manufacturer, poorly cleaned. Most assigned NA}
\item{travel_distance}{Distance travelled, not cleaned. Mixed formats}
\item{speed_fpm}{Speed in feet/minute}
\item{capacity_lbs}{Capacity in lbs}
\item{car_buffer_type}{Buffer type. A buffer is a device designed to stop
a descending car or counterweight beyond its normal limit and to soften
the force with which the elevator runs into the pit during an emergency.
Takes values "Oil", "Spring", and NA}
\item{governor_type}{Governor type, An overspeed governor is an elevator
device which acts as a stopping mechanism in case the elevator runs beyond
its rated speed}
\item{machine_type}{Machine type, labels unknown.}
\item{safety_type}{Safety type, labels unknown.}
\item{mode_operation}{Operation mode, labels unknown.}
\item{floor_from}{Lowest floor, not cleaned. Mixed formats}
\item{floor_to}{Highest floor, not cleaned. Mixed formats}
\item{latitude}{Latitude of elevator}
\item{longitude}{Longitude of elevator}
\item{elevators_per_building}{number of elevators in building}
...
}
}
\section{tibble print}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{data_elevators()
#> # A tibble: 35,042 x 25
#>    device_number bin     tax_block tax_lot house_number street_name     zip_code
#>    <chr>         <chr>   <chr>     <chr>   <chr>        <chr>           <chr>   
#>  1 1D10028       1024795 1021      26      1614         BROADWAY        10019   
#>  2 1D10094       1041822 1392      25      53           E 77TH ST       10021   
#>  3 1D10097       1038223 1323      1       201          E 49 ST         10017   
#>  4 1D10146       1080443 1274      6       40           CENTRAL PARK S~ <NA>    
#>  5 1D10200       1085777 1074      24      651          TENTH AVENUE    <NA>    
#>  6 1D10301       1002075 181       16      179          FRANKLIN STREET 10013   
#>  7 1D10302       1010518 606       4       121          WEST 10 STREET  10011   
#>  8 1D10303       1085955 1329      1       915          3 AVENUE        10022   
#>  9 1D10304       1044058 1430      5       220          E. 76 ST        10021   
#> 10 1D10305       1087468 1951      4       133          MORNINGSIDE AV~ <NA>    
#> # i 35,032 more rows
#> # i 18 more variables: borough <fct>, device_type <chr>,
#> #   lastper_insp_date <date>, approval_date <date>, manufacturer <chr>,
#> #   travel_distance <chr>, speed_fpm <dbl>, capacity_lbs <dbl>,
#> #   car_buffer_type <chr>, governor_type <chr>, machine_type <chr>,
#> #   safety_type <chr>, mode_operation <chr>, floor_from <chr>, floor_to <chr>,
#> #   latitude <dbl>, longitude <dbl>, elevators_per_building <int>
}\if{html}{\out{</div>}}
}

\section{glimpse()}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{tibble::glimpse(data_elevators())
#> Rows: 35,042
#> Columns: 25
#> $ device_number          <chr> "1D10028", "1D10094", "1D10097", "1D10146", "1D~
#> $ bin                    <chr> "1024795", "1041822", "1038223", "1080443", "10~
#> $ tax_block              <chr> "1021", "1392", "1323", "1274", "1074", "181", ~
#> $ tax_lot                <chr> "26", "25", "1", "6", "24", "16", "4", "1", "5"~
#> $ house_number           <chr> "1614", "53", "201", "40", "651", "179", "121",~
#> $ street_name            <chr> "BROADWAY", "E 77TH ST", "E 49 ST", "CENTRAL PA~
#> $ zip_code               <chr> "10019", "10021", "10017", NA, NA, "10013", "10~
#> $ borough                <fct> Manhattan, Manhattan, Manhattan, Manhattan, Man~
#> $ device_type            <chr> "Dumbwaiter", "Dumbwaiter", "Dumbwaiter", "Dumb~
#> $ lastper_insp_date      <date> 2015-09-18, 2015-08-07, 2015-04-02, 2014-10-15~
#> $ approval_date          <date> 2006-03-07, 2006-05-15, 1998-09-21, 2010-08-02~
#> $ manufacturer           <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,~
#> $ travel_distance        <chr> "16'4\\"", NA, "23", "8'", "24 FT", "9'0", "12'0~
#> $ speed_fpm              <dbl> 50, 25, 50, 50, 50, 50, 50, 50, 50, 100, 100, 5~
#> $ capacity_lbs           <dbl> 500, 500, 500, 500, NA, 500, 300, 500, 500, 500~
#> $ car_buffer_type        <chr> "Spring", NA, NA, NA, NA, NA, "Spring", NA, NA,~
#> $ governor_type          <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,~
#> $ machine_type           <chr> NA, "OD", "BD", "BD", NA, "OD", "OD", "BD", "OG~
#> $ safety_type            <chr> "I", NA, "I", NA, NA, "I", "I", NA, "I", NA, NA~
#> $ mode_operation         <chr> "A", "P", "A", "A", NA, "A", "A", "A", "A", "P"~
#> $ floor_from             <chr> "B", "SB", "B", "B", "C", "BAS", "B", "C", "BMT~
#> $ floor_to               <chr> "1", "3", "2", "1", "G", "1", "1", "2", "4", "5~
#> $ latitude               <dbl> 40.76088, 40.77502, 40.75518, 40.76500, 40.7622~
#> $ longitude              <dbl> -73.98391, -73.96256, -73.97079, -73.97573, -73~
#> $ elevators_per_building <int> 11, 2, 1, 1, 2, 2, 1, 1, 1, 5, 5, 1, 2, 1, 1, 2~
}\if{html}{\out{</div>}}
}

\examples{
\donttest{
data_elevators()
}
}
