% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{lkh.norm}
\alias{lkh.norm}
\title{Weighted Normal Likelihood for Independent Variables}
\usage{
lkh.norm(y, mu, s, w = NULL)
}
\arguments{
\item{y}{observations, a reference object of class 'number'}

\item{mu}{mean, a refernce object of class 'number'}

\item{s}{standard deviation, a reference object of class 'number'}

\item{w}{weights, a reference object of class 'number'}
}
\value{
Returns a reference object of class 'number'
}
\description{
Calculates the weighted Normal Likelihood for independent variables
\deqn{lkh = \sum_i{w_i * ldnorm(y_i, \mu_i, \sigma_i)}}
}
\examples{
modello.init(10, 10, 10, 10)
y = number(rnorm(10), dx=FALSE)
mu = number(rep(0, 10))
s = number(rep(1, 10))
w = number(runif(10))
lkh = lkh.norm(y, mu, s, w)
print(lkh)
print(lkh$v)
modello.close()
}
\author{
Filippo Monari
}
