% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_crosstab.R
\name{datasummary_crosstab}
\alias{datasummary_crosstab}
\title{Cross tabulations for categorical variables}
\usage{
datasummary_crosstab(
  formula,
  statistic = 1 ~ 1 + N + Percent("row"),
  data,
  output = "default",
  fmt = 1,
  title = NULL,
  notes = NULL,
  align = NULL,
  add_columns = NULL,
  add_rows = NULL,
  sparse_header = TRUE,
  escape = TRUE,
  ...
)
}
\arguments{
\item{formula}{A two-sided formula to describe the table: rows ~ columns,
where rows and columns are variables in the data. Rows and columns may
contain interactions, e.g., \code{var1 * var2 ~ var3}.}

\item{statistic}{A formula of the form \code{1 ~ 1 + N + Percent("row")}. The
left-hand side may only be empty or contain a \code{1} to include row totals.
The right-hand side may contain: \code{1} for column totals, \code{N} for counts,
\code{Percent()} for cell percentages, \code{Percent("row")} for row percentages,
\code{Percent("col")} for column percentages.}

\item{data}{A data.frame (or tibble)}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .docx, .html, .tex, .md, .txt, .png, .jpg.
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "gt", "kableExtra", "huxtable", "flextable", "jupyter". The "modelsummary_list" value produces a lightweight object which can be saved and fed back to the \code{modelsummary} function.
\item Warning: Users should not supply a file name to the \code{output} argument if they intend to customize the table with external packages. See the 'Details' section.
\item LaTeX compilation requires the \code{booktabs} and \code{siunitx} packages, but \code{siunitx} can be disabled or replaced with global options. See the 'Details' section.
\item The default output formats and table-making packages can be modified with global options. See the 'Details' section.
}}

\item{fmt}{determines how to format numeric values
\itemize{
\item integer: the number of digits to keep after the period \code{format(round(x, fmt), nsmall=fmt)}
\item character: passed to the \code{sprintf} function (e.g., '\%.3f' keeps 3 digits with trailing zero). See \code{?sprintf}
\item function: returns a formatted character string.
\item LaTeX output: To ensure proper typography, all numeric entries are enclosed in the \verb{\\num\{\}} command, which requires the \code{siunitx} package to be loaded in the LaTeX preamble. This behavior can be altered with global options. See the 'Details' section.
}}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{align}{A string with a number of characters equal to the number of columns in
the table (e.g., \code{align = "lcc"}).  Valid characters: l, c, r, S.
\itemize{
\item "l": left-aligned column
\item "c": centered column
\item "r": right-aligned column
\item "d": dot-aligned column. Only supported for LaTeX/PDF tables produced by \code{kableExtra}. These commands must appear in the LaTeX preamble (they are added automatically when compiling Rmarkdown documents to PDF):
\itemize{
\item \verb{\\usepackage\{booktabs\}}
\item \verb{\\usepackage\{siunitx\}}
\item \verb{\\newcolumntype\{d\}\{S[input-symbols = ()]\}}
}
}}

\item{add_columns}{a data.frame (or tibble) with the same number of rows as
your main table.}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See Examples section below.}

\item{sparse_header}{TRUE or FALSE. TRUE eliminates column headers which
have a unique label across all columns, except for the row immediately above
the data. FALSE keeps all headers. The order in which terms are entered in
the formula determines the order in which headers appear. For example,
\code{x~mean*z} will print the \code{mean}-related header above the \code{z}-related
header.`}

\item{escape}{boolean TRUE escapes or substitutes LaTeX/HTML characters which could
prevent the file from compiling/displaying. This setting does not affect captions or notes.}

\item{...}{all other arguments are passed through to the
table-making functions. This allows users to pass arguments directly to
\code{datasummary} in order to affect the behavior of other functions behind
the scenes, for instance:
\itemize{
\item \code{kableExtra::kbl(escape=FALSE)} to avoid escaping math characters in \code{kableExtra} tables.
}}
}
\description{
Convenience function to tabulate counts, cell percentages, and row/column
percentages for categorical variables. See the Details section for a
description of the internal design. For more complex cross tabulations, use
\link{datasummary} directly.
}
\details{
\code{datasummary_crosstab} is a wrapper around the \link{datasummary}
function. This wrapper works by creating a customized formula and by
feeding it to \code{datasummary}. The customized formula comes in two parts.

First, we take a two-sided formula supplied by the \code{formula} argument.
All variables of that formula are wrapped in a \code{Factor()} call to ensure
that the variables are treated as categorical.

Second, the \code{statistic} argument gives a two-sided formula which specifies
the statistics to include in the table. \code{datasummary_crosstab} modifies
this formula automatically to include "clean" labels.

Finally, the \code{formula} and \code{statistic} formulas are combined into a single
formula which is fed directly to the \code{datasummary} function to produce the
table.

Variables in \code{formula} are automatically wrapped in \code{Factor()}.
}
\section{Global Options}{


The behavior of \code{modelsummary} can be affected by setting global options:
\itemize{
\item \code{modelsummary_factory_default}
\item \code{modelsummary_factory_latex}
\item \code{modelsummary_factory_html}
\item \code{modelsummary_factory_png}
\item \code{modelsummary_get}
\item \code{modelsummary_format_numeric_latex}
\item \code{modelsummary_format_numeric_html}
}
\subsection{Table-making packages}{

\code{modelsummary} supports 4 table-making packages: \code{kableExtra}, \code{gt},
\code{flextable}, and \code{huxtable}. Some of these packages have overlapping
functionalities. For example, 3 of those packages can export to LaTeX. To
change the default backend used for a specific file format, you can use
the \code{options} function:

\code{options(modelsummary_factory_html = 'kableExtra')}
\code{options(modelsummary_factory_latex = 'gt')}
\code{options(modelsummary_factory_word = 'huxtable')}
\code{options(modelsummary_factory_png = 'gt')}
}

\subsection{Model extraction functions}{

\code{modelsummary} can use two sets of packages to extract information from
statistical models: \code{broom} and the \code{easystats} family (\code{performance} and
\code{parameters}). By default, it uses \code{broom} first and \code{easystats} as a
fallback if \code{broom} fails. You can change the order of priorities
or include goodness-of-fit extracted by \emph{both} packages by setting:

\code{options(modelsummary_get = "broom")}
\code{options(modelsummary_get = "easystats")}
\code{options(modelsummary_get = "all")}
}

\subsection{Formatting numeric entries}{

By default, LaTeX tables enclose all numeric entries in the \verb{\\num\{\}} command
from the siunitx package. To prevent this behavior, or to enclose numbers
in dollar signs (for LaTeX math mode), users can call:

\code{options(modelsummary_format_numeric_latex = "plain")}
\code{options(modelsummary_format_numeric_latex = "mathmode")}

A similar option can be used to display numerical entries using MathJax in
HTML tables:

\code{options(modelsummary_format_numeric_html = "mathjax")}
}
}

\examples{
\dontrun{
  # crosstab of two variables, showing counts, row percentages, and row/column totals
  datasummary_crosstab(cyl ~ gear, data = mtcars)

  # crosstab of two variables, showing counts only and no totals
  datasummary_crosstab(cyl ~ gear, statistic = ~ N, data = mtcars)

  # crosstab of three variables
  datasummary_crosstab(am * cyl ~ gear, data = mtcars)
  
  # crosstab with two variables and column percentages 
  datasummary_crosstab(am ~ gear, statistic = ~ Percentage("col"), data = mtcars)
}

}
