% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary.R
\name{datasummary}
\alias{datasummary}
\title{Summary tables using 2-sided formulae: crosstabs, frequencies, table
1s and more.}
\usage{
datasummary(
  formula,
  data,
  output = getOption("modelsummary_output", default = "default"),
  fmt = 2,
  title = getOption("modelsummary_title", default = NULL),
  notes = getOption("modelsummary_notes", default = NULL),
  align = getOption("modelsummary_align", default = NULL),
  add_columns = getOption("modelsummary_add_columns", default = NULL),
  add_rows = getOption("modelsummary_add_rows", default = NULL),
  sparse_header = getOption("modelsummary_sparse_header", default = TRUE),
  escape = getOption("modelsummary_escape", default = TRUE),
  ...
)
}
\arguments{
\item{formula}{A two-sided formula to describe the table: rows ~ columns.
See the Examples section for a mini-tutorial and the Details section for
more resources. Grouping/nesting variables can appear on both sides of the
formula, but all summary functions must be on one side.}

\item{data}{A data.frame (or tibble)}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .docx, .html, .tex, .md, .txt, .csv, .xlsx, .png, .jpg
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "typst", "data.frame", "tinytable", "gt", "kableExtra", "huxtable", "flextable", "DT", "jupyter". The "modelsummary_list" value produces a lightweight object which can be saved and fed back to the \code{modelsummary} function.
\item The "default" output format can be set to "tinytable", "kableExtra", "gt", "flextable", "huxtable", "DT", or "markdown"
\itemize{
\item If the user does not choose a default value, the packages listed above are tried in sequence.
\item Session-specific configuration: \code{options("modelsummary_factory_default" = "gt")}
\item Persistent configuration: \code{config_modelsummary(output = "markdown")}
}
\item Warning: Users should not supply a file name to the \code{output} argument if they intend to customize the table with external packages. See the 'Details' section.
\item LaTeX compilation requires the \code{booktabs} and \code{siunitx} packages, but \code{siunitx} can be disabled or replaced with global options. See the 'Details' section.
}}

\item{fmt}{how to format numeric values: integer, user-supplied function, or \code{modelsummary} function.
\itemize{
\item Integer: Number of decimal digits
\item User-supplied functions:
\itemize{
\item Any function which accepts a numeric vector and returns a character vector of the same length.
}
\item \code{modelsummary} functions:
\itemize{
\item \code{fmt = fmt_significant(2)}: Two significant digits (at the term-level)
\item \code{fmt = fmt_sprintf("\%.3f")}: See \code{?sprintf}
\item \code{fmt = fmt_identity()}: unformatted raw values
}
}}

\item{title}{string. Cross-reference labels should be added with Quarto or Rmarkdown chunk options when applicable. When saving standalone LaTeX files, users can add a label such as \verb{\\\\label\{tab:mytable\}} directly to the title string, while also specifying \code{escape=FALSE}.}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{align}{A string with a number of characters equal to the number of columns in
the table (e.g., \code{align = "lcc"}).  Valid characters: l, c, r, d.
\itemize{
\item "l": left-aligned column
\item "c": centered column
\item "r": right-aligned column
\item "d": dot-aligned column. For LaTeX/PDF output, this option requires at least version 3.0.25 of the siunitx LaTeX package. See the LaTeX preamble help section below for commands to insert in your LaTeX preamble.
}}

\item{add_columns}{a data.frame (or tibble) with the same number of rows as
your main table.}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See Examples section below.}

\item{sparse_header}{TRUE or FALSE. TRUE eliminates column headers which
have a unique label across all columns, except for the row immediately above
the data. FALSE keeps all headers. The order in which terms are entered in
the formula determines the order in which headers appear. For example,
\code{x~mean*z} will print the \code{mean}-related header above the \code{z}-related
header.`}

\item{escape}{boolean TRUE escapes or substitutes LaTeX/HTML characters which could
prevent the file from compiling/displaying. \code{TRUE} escapes all cells, captions, and notes. Users can have more fine-grained control by setting \code{escape=FALSE} and using an external command such as: \code{modelsummary(model, "latex") |> tinytable::format_tt(tab, j=1:5, escape=TRUE)}}

\item{...}{all other arguments are passed through to the table-making
functions \link[tinytable:tt]{tinytable::tt}, \link[kableExtra:kbl]{kableExtra::kbl}, \link[gt:gt]{gt::gt}, \link[DT:datatable]{DT::datatable}, etc. depending on the \code{output} argument.
This allows users to pass arguments directly to \code{datasummary} in order to
affect the behavior of other functions behind the scenes.}
}
\description{
\code{datasummary} can use any summary function which produces one numeric or
character value per variable. The examples section of this documentation
shows how to define custom summary functions.

\code{modelsummary} also supplies several shortcut summary functions which can be used in \code{datasummary()} formulas: Min, Max, Mean, Median, Var, SD, NPercent, NUnique, Ncol, P0, P25, P50, P75, P100.

See the Details and Examples sections below, and the vignettes on the \code{modelsummary} website:
\itemize{
\item https://modelsummary.com/
\item https://modelsummary.com/articles/datasummary.html
}
}
\details{
Visit the 'modelsummary' website for more usage examples:
https://modelsummary.com

The 'datasummary' function is a thin wrapper around the 'tabular' function
from the 'tables' package. More details about table-making formulas can be
found in the 'tables' package documentation: ?tables::tabular

Hierarchical or "nested" column labels are only available for these output
formats: tinytable, kableExtra, gt, html, rtf, and LaTeX. When saving tables to other
formats, nested labels will be combined to a "flat" header.
}
\section{Version 2.0.0, kableExtra, and tinytable}{


Since version 2.0.0, \code{modelsummary} uses \code{tinytable} as its default table-drawing backend.
Learn more at: https://vincentarelbundock.github.io/tinytable/",

Revert to \code{kableExtra} for one session:

\code{options(modelsummary_factory_default = 'kableExtra')}
\code{options(modelsummary_factory_latex = 'kableExtra')}
\code{options(modelsummary_factory_html = 'kableExtra')}
}

\section{Global Options}{


The behavior of \code{modelsummary} can be modified by setting global options.  In particular, most of the arguments for most of the package's functions cna be set using global options. For example:
\itemize{
\item \code{options(modelsummary_output = "modelsummary_list")}
\item \code{options(modelsummary_statistic = '({conf.low}, {conf.high})')}
\item \code{options(modelsummary_stars = TRUE)}
}

Options not specific to given arguments are listed below.
\subsection{Model labels: default column names}{

These global option changes the style of the default column headers:
\itemize{
\item \code{options(modelsummary_model_labels = "roman")}
}

The supported styles are: "model", "arabic", "letters", "roman", "(arabic)", "(letters)", "(roman)"
}

\subsection{Table-making packages}{

\code{modelsummary} supports 6 table-making packages: \code{tinytable}, \code{kableExtra}, \code{gt},
\code{flextable}, \code{huxtable}, and \code{DT}. Some of these packages have overlapping
functionalities. To change the default backend used for a specific file
format, you can use ' the \code{options} function:

\code{options(modelsummary_factory_html = 'kableExtra')}
\code{options(modelsummary_factory_word = 'huxtable')}
\code{options(modelsummary_factory_png = 'gt')}
\code{options(modelsummary_factory_latex = 'gt')}
\code{options(modelsummary_factory_latex_tabular = 'kableExtra')}
}

\subsection{Table themes}{

Change the look of tables in an automated and replicable way, using the \code{modelsummary} theming functionality. See the vignette: https://modelsummary.com/articles/appearance.html
\itemize{
\item \code{modelsummary_theme_gt}
\item \code{modelsummary_theme_kableExtra}
\item \code{modelsummary_theme_huxtable}
\item \code{modelsummary_theme_flextable}
\item \code{modelsummary_theme_dataframe}
}
}

\subsection{Model extraction functions}{

\code{modelsummary} can use two sets of packages to extract information from
statistical models: the \code{easystats} family (\code{performance} and \code{parameters})
and \code{broom}. By default, it uses \code{easystats} first and then falls back on
\code{broom} in case of failure. You can change the order of priorities or include
goodness-of-fit extracted by \emph{both} packages by setting:

\code{options(modelsummary_get = "easystats")}

\code{options(modelsummary_get = "broom")}

\code{options(modelsummary_get = "all")}
}

\subsection{Formatting numeric entries}{

By default, LaTeX tables enclose all numeric entries in the \verb{\\num\{\}} command
from the siunitx package. To prevent this behavior, or to enclose numbers
in dollar signs (for LaTeX math mode), users can call:

\code{options(modelsummary_format_numeric_latex = "plain")}

\code{options(modelsummary_format_numeric_latex = "mathmode")}

A similar option can be used to display numerical entries using MathJax in
HTML tables:

\code{options(modelsummary_format_numeric_html = "mathjax")}
}
}

\section{LaTeX preamble}{


When creating LaTeX via the \code{tinytable} backend (default in version 2.0.0 and later), it is useful to include the following commands in the LaTeX preamble of your documents. These commands are automatically added to the preamble when compiling Rmarkdown or Quarto documents, except when the \code{modelsummary()} calls are cached.

\if{html}{\out{<div class="sourceCode latex">}}\preformatted{\\usepackage\{tabularray\}
\\usepackage\{float\}
\\usepackage\{graphicx\}
\\usepackage[normalem]\{ulem\}
\\UseTblrLibrary\{booktabs\}
\\UseTblrLibrary\{siunitx\}
\newcommand{\tinytableTabularrayUnderline}[1]\{\\underline\{#1\}\}
\newcommand{\tinytableTabularrayStrikeout}[1]\{\\sout\{#1\}\}
\\NewTableCommand\{\\tinytableDefineColor\}[3]\{\\definecolor\{#1\}\{#2\}\{#3\}\}
}\if{html}{\out{</div>}}
}

\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(modelsummary)

# The left-hand side of the formula describes rows, and the right-hand side
# describes columns. This table uses the "mpg" variable as a row and the "mean"
# function as a column:

datasummary(mpg ~ mean, data = mtcars)

# This table uses the "mean" function as a row and the "mpg" variable as a column:

datasummary(mean ~ mpg, data = mtcars)

# Display several variables or functions of the data using the "+"
# concatenation operator. This table has 2 rows and 2 columns:

datasummary(hp + mpg ~ mean + sd, data = mtcars)

# Nest variables or statistics inside a "factor" variable using the "*" nesting
# operator. This table shows the mean of "hp" and "mpg" for each value of
# "cyl":

mtcars$cyl <- as.factor(mtcars$cyl)
datasummary(hp + mpg ~ cyl * mean, data = mtcars)

# If you don't want to convert your original data
# to factors, you can use the 'Factor()'
# function inside 'datasummary' to obtain an identical result:

datasummary(hp + mpg ~ Factor(cyl) * mean, data = mtcars)

# You can nest several variables or statistics inside a factor by using
# parentheses. This table shows the mean and the standard deviation for each
# subset of "cyl":

datasummary(hp + mpg ~ cyl * (mean + sd), data = mtcars)

# Summarize all numeric variables with 'All()'
datasummary(All(mtcars) ~ mean + sd, data = mtcars)

# Define custom summary statistics. Your custom function should accept a vector
# of numeric values and return a single numeric or string value:

minmax <- function(x) sprintf("[\%.2f, \%.2f]", min(x), max(x))
mean_na <- function(x) mean(x, na.rm = TRUE)

datasummary(hp + mpg ~ minmax + mean_na, data = mtcars)

# To handle missing values, you can pass arguments to your functions using
# '*Arguments()'

datasummary(hp + mpg ~ mean * Arguments(na.rm = TRUE), data = mtcars)

# For convenience, 'modelsummary' supplies several convenience functions
# with the argument `na.rm=TRUE` by default: Mean, Median, Min, Max, SD, Var,
# P0, P25, P50, P75, P100, NUnique, Histogram

#datasummary(hp + mpg ~ Mean + SD + Histogram, data = mtcars)

# These functions also accept a 'fmt' argument which allows you to
# round/format the results

datasummary(hp + mpg ~ Mean * Arguments(fmt = "\%.3f") + SD * Arguments(fmt = "\%.1f"), data = mtcars)

# Save your tables to a variety of output formats:
f <- hp + mpg ~ Mean + SD
#datasummary(f, data = mtcars, output = 'table.html')
#datasummary(f, data = mtcars, output = 'table.tex')
#datasummary(f, data = mtcars, output = 'table.md')
#datasummary(f, data = mtcars, output = 'table.docx')
#datasummary(f, data = mtcars, output = 'table.pptx')
#datasummary(f, data = mtcars, output = 'table.jpg')
#datasummary(f, data = mtcars, output = 'table.png')

# Display human-readable code
#datasummary(f, data = mtcars, output = 'html')
#datasummary(f, data = mtcars, output = 'markdown')
#datasummary(f, data = mtcars, output = 'latex')

# Return a table object to customize using a table-making package
#datasummary(f, data = mtcars, output = 'tinytable')
#datasummary(f, data = mtcars, output = 'gt')
#datasummary(f, data = mtcars, output = 'kableExtra')
#datasummary(f, data = mtcars, output = 'flextable')
#datasummary(f, data = mtcars, output = 'huxtable')

# add_rows
new_rows <- data.frame(a = 1:2, b = 2:3, c = 4:5)
attr(new_rows, 'position') <- c(1, 3)
datasummary(mpg + hp ~ mean + sd, data = mtcars, add_rows = new_rows)
}\if{html}{\out{</div>}}
}

\references{
Arel-Bundock V (2022). “modelsummary: Data and Model Summaries in R.” \emph{Journal of Statistical Software}, \emph{103}(1), 1-23. \doi{10.18637/jss.v103.i01}.'
}
