% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cv_split}
\alias{cv_split}
\title{Generate cross-validation fold indices}
\usage{
cv_split(data, v = 5, seed = NULL)
}
\arguments{
\item{data}{A data frame or matrix.}

\item{v}{Integer. Number of folds. Defaults to 5.}

\item{seed}{Optional integer. Random seed for reproducibility.}
}
\value{
A list of length \code{v}, where each element is a vector of row indices for that fold.
}
\description{
Splits row indices of a data frame or matrix into \code{k} folds for cross-validation.
}
\examples{
folds <- cv_split(mtcars, v = 5)
str(folds)

}
