% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem-package.R, R/modsem.R
\name{modsem}
\alias{modsem}
\title{Interaction between latent variables}
\usage{
modsem(
  modelSyntax = NULL,
  data = NULL,
  method = "dblcent",
  match = FALSE,
  standardizeData = FALSE,
  centerData = FALSE,
  firstLoadingFixed = TRUE,
  centerBefore = NULL,
  centerAfter = NULL,
  residualsProds = NULL,
  residualCovSyntax = NULL,
  constrainedProdMean = NULL,
  constrainedLoadings = NULL,
  constrainedVar = NULL,
  constrainedResCovMethod = NULL,
  auto.scale = "none",
  auto.center = "none",
  estimator = "ML",
  removeFromParTable = NULL,
  addToParTable = NULL,
  macros = NULL,
  run = TRUE,
  ...
)
}
\arguments{
\item{modelSyntax}{lavaan syntax}

\item{data}{dataframe}

\item{method}{method to use:
"rca" = residual centering approach (passed to lavaan),
"uca" = unconstrained approach (passed to lavaan),
"dblcent" = double centering approach (passed to lavaan),
"pind" = prod ind approach, with no constraints or centering (passed to lavaan),
"lms" = laten model structural equations (not passed to lavaan).
"qml" = quasi maximum likelihood estimation of laten model structural equations (not passed to lavaan).
"custom" = use parameters specified in the function call (passed to lavaan)}

\item{match}{should the product indicators be created by using the match-strategy}

\item{standardizeData}{should data be scaled before fitting model}

\item{centerData}{should data be centered before fitting model}

\item{firstLoadingFixed}{Sould the first factorloading in the latent prod be fixed to one?}

\item{centerBefore}{should inds in prods be centered before computing prods (overwritten by method, if method != NULL)}

\item{centerAfter}{should ind prods be centered after they have been computed?}

\item{residualsProds}{should ind prods be centered using residuals (overwritten by method, if method != NULL)}

\item{residualCovSyntax}{should syntax for residual covariances be produced (overwritten by method, if method != NULL)}

\item{constrainedProdMean}{should syntax prod mean be produced (overwritten by method, if method != NULL)}

\item{constrainedLoadings}{should syntax for constrained loadings be produced (overwritten by method, if method != NULL)}

\item{constrainedVar}{should syntax for constrained variances be produced (overwritten by method, if method != NULL)}

\item{constrainedResCovMethod}{method for constraining residual covariances}

\item{auto.scale}{methods which should be scaled automatically (usually not useful)}

\item{auto.center}{methods which should be centered automatically (usually not useful)}

\item{estimator}{estimator to use in lavaan}

\item{removeFromParTable}{rows to remove from partable before sending to lavaan (for advanced users)}

\item{addToParTable}{rows to add to partable before sending to lavaan (for advanced users)}

\item{macros}{macros to replace in the syntax before sending to lavaan}

\item{run}{should the model be estimated}

\item{...}{arguments passed to other functions, e.g,. lavaan}
}
\value{
ModSEM object
}
\description{
modsem is a function for estimating interaction effects between latent variables, 
in structural equation models (SEM's).
Methods for estimating interaction effects in SEM's can basically be split into 
two frameworks: 1. Product Indicator based approaches ("dblcent", "rca", "uca", 
"ca", "pind"), and 2. Distributionally based approaches ("lms", "qml").
For the product indicator based approaces, modsem() is essentially a just 
a fancy wrapper for lavaan::sem()  which generates the 
necessary syntax, and variables for the estimation of models with latent product indicators.
The distributionally based approaches are implemented in seperately, and are 
are not estimated using lavaan::sem(), but rather using custom functions (largely)
written in C++ for performance reasons.
}
\examples{
library(modsem)
# For more examples check README and/or GitHub.
# One interaction
m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3
  
  # Inner model
  Y ~ X + Z + X:Z 
'

# Double centering approach
est1 <- modsem(m1, oneInt)
summary(est1)

# Theory Of Planned Behavior
tpb <- ' 
# Outer Model (Based on Hagger et al., 2007)
  LATT =~ att1 + att2 + att3 + att4 + att5
  LSN =~ sn1 + sn2
  LPBC =~ pbc1 + pbc2 + pbc3
  LINT =~ int1 + int2 + int3
  LBEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Covariances
  LATT ~~ LSN + LPBC
  LPBC ~~ LSN 
  # Causal Relationsships
  LINT ~ LATT + LSN + LPBC
  LBEH ~ LINT + LPBC 
  LBEH ~ LINT:LPBC  
'

# double centering approach
estTpb <- modsem(tpb, data = TPB)
summary(estTpb)
}
