% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{determine_drug_targets}
\alias{determine_drug_targets}
\title{Determine drug target nodes in network}
\usage{
determine_drug_targets(graphs, annotations, drug_target_interaction, settings)
}
\arguments{
\item{graphs}{A named list with elements `group1` and `group2` containing the combined graphs
of each group as iGraph object.}

\item{annotations}{List of data frames that map node IDs to identifiers. Contains `all`
(unique identifiers across the whole data) and `group1` and `group2` containing identifiers
specific to the strata.}

\item{drug_target_interaction}{Named list specifying drug target interactions for drug response
score computation}

\item{settings}{A named list containing pipeline settings}
}
\value{
A named list with elements `drug_targets` and `drug_target_edge_list`.
* `targets` is a named list with elements `target_nodes` and `drugs_to_target_nodes`.
`target_nodes` is a data frame with column `node_id` (unique node IDs in the iGraph object
targeted by drugs) and columns `group1` and `group2` (boolean values specifying whether the
node is contained in the combined graph of the group). Element `drugs_to_target_nodes` contains
 a named list mapping drug names to a vector of their target node IDs.
* `drug_target_edge_list` contains elements `group1` and `group2` containing each a list of
edges adjacent to drug target nodes.
}
\description{
Finds node IDs of network nodes in `graphs` that are targeted by a drug in
`drug_target_interaction`. Returns list of node ids and list of adjacent edges.
}
\examples{
data(drug_gene_interactions)
data(combined_graphs_example)
combined_graphs <- combined_graphs_example
settings <- molnet_settings()
drug_target_interaction <- make_drug_target(target_molecules='protein',
interaction_table=drug_gene_interactions,
match_on='gene_name')
drug_targets <- determine_drug_targets(combined_graphs[["graphs"]],
combined_graphs[["annotations"]],
drug_target_interaction,
settings)

}
