% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pwdist.R
\name{pwdist}
\alias{pwdist}
\title{Pairwise Euclidean distances between landmarks}
\usage{
pwdist(x, average = TRUE)
}
\arguments{
\item{x}{a two-column matrix for the xy landmark coordinates}

\item{average}{if TRUE, the pairwise distances for both left and right anchors are averaged. For data quality checks, set to FALSE}
}
\description{
This function computes all possible \emph{n(n-1)/2} pairwise Euclidean distances between \emph{n} landmarks.
}
\details{
Comparison of the pairs of pairwise Euclidean distance from the left and right form of anchors is
the basis of the quality control procedure implemented in \code{Qscore}. In addition, pairwise Euclidean distances
provide length variables useful for the analysis of size variation (Lele & Richtsmeier, 2001).
}
\examples{
library(cluster)

data(ligophorus_tpsdata)

#There are 11 landmarks for the ventral and dorsal anchors,
#yielding 110 pairwise Euclidean distances
#The indices for the pairwise Euclidean distances map to the upper triangle
#of the pairwise distance matrix by row
pwdist(ligophorus_tpsdata$bantingensis[[1]],average=FALSE)
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2016). Monogenean anchor morphometry: systematic value, phylogenetic signal, and evolution. PeerJ 4:e1668.

Lele SR,  Richtsmeier  JT. 2001. An Invariant Approach to Statistical Analysis of Shape. Boca Raton: Chapman and Hall.
}

