#******************************************************************************* 
#
# Estimation for Multivariate Normal Data with Monotone Missingness
# Copyright (C) 2007, University of Cambridge
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Questions? Contact Robert B. Gramacy (bobby@statslab.cam.ac.uk)
#
#*******************************************************************************


## posdef.approx
##
## uses sechol in library(accuracy) to find the nearest
## positive definite matrix to S

`posdef.approx` <-
function(S, name="S", quiet=FALSE)
{
  ## sanity check
  if(!is.matrix(S) || nrow(S) != ncol(S))
    stop(paste(name, "needs to be a symmetric matrix"))
  
  if(class(try(chol(S), silent=TRUE)) == "try-error") {

    ## check that library(accuracy) can be loaded
    if(require(accuracy, quietly=TRUE) == FALSE) {
      warning(paste(name, "is not pos-def, install library(accuracy) for nearest approx"))
      return(S)
    } else if(!quiet) warning(paste(name, "is not pos-def, using nearest approx"))

    ## make the approximation
    S.sechol <- sechol(S)
    S <- t(S.sechol) %*% S.sechol
  }

  return(S)
}

