% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{compute_eaf_call}
\alias{compute_eaf_call}
\title{Same as \code{\link[=eaf]{eaf()}} but performs no checks and does not transform the input or
the output. This function should be used by other packages that want to
avoid redundant checks and transformations.}
\usage{
compute_eaf_call(x, cumsizes, percentiles)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values that represents multiple sets of points, where each row represents
a point. If \code{sets} is missing, the last column of \code{x} gives the sets.}

\item{cumsizes}{\code{integer()}\cr Cumulative size of the different sets of points in \code{x}.}

\item{percentiles}{\code{numeric()}\cr Vector indicating which percentiles are
computed.  \code{NULL} computes all.}
}
\value{
\code{data.frame()}\cr A data frame containing the exact representation
of EAF. The last column gives the percentile that corresponds to each
point. If groups is not \code{NULL}, then an additional column indicates to
which group the point belongs.
}
\description{
Same as \code{\link[=eaf]{eaf()}} but performs no checks and does not transform the input or
the output. This function should be used by other packages that want to
avoid redundant checks and transformations.
}
\seealso{
\code{\link[=as_double_matrix]{as_double_matrix()}} \code{\link[=transform_maximise]{transform_maximise()}}
}
\concept{eaf}
