% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mopaTrain.R
\name{modelo}
\alias{modelo}
\title{Species distribution modeling and cross validation}
\usage{
modelo(kdata, data, algorithm = c("glm", "svm", "maxent", "mars", "rf",
  "cart.rpart", "cart.tree"), algorithm.args = NULL, weighting = FALSE,
  threshold = NULL, tuneRF.args = NULL)
}
\arguments{
\item{kdata}{Object returned by function leaveOneOut}

\item{data}{Object returned by function biomat. 2D matrix with the dependent variable 
(presence/absence) in the first column and the independent variables in the rest 
(extracted from varstack)}

\item{algorithm}{Any character of the following: \code{"glm"}, "svm", "maxent", "mars", "rf", "cart.rpart" 
or "cart.tree"}

\item{algorithm.args}{Further arguments to be passed to the selected algorithm for modeling (functions involved 
are described in details)}

\item{weighting}{Logical for model fitting with weighted presence/absences-s. Applicable for algorithms "glm", "mars", 
"rf" and "cart.rpart". Default is FALSE.}

\item{threshold}{Cut value between 0 and 1 to calculate the confusion matrix. Default is 0.5.}

\item{tuneRF.args}{list of arguments from function \code{\link[randomForest]{tuneRF}}. Only used when algorihm = "rf"}
}
\value{
A list with six components:
 \item{model }{fitted model using all data for training}
 \item{auc }{AUC statistic in the cross validation}
 \item{kappa }{kappa statistic in the cross validation}
 \item{tss }{true skill statistic in the cross validation }
 \item{fold.models }{fitted model with partitioned data}
 \item{ObsPred }{cross model prediction}
}
\description{
Species distribution modeling with k-fold cross validation. 
Algorithms supported are "glm", "svm", "maxent", "mars", "rf", "cart.rpart" 
and "cart.tree"
}
\details{
This function calculates the AUC with the function "auc" from package 
"PresenceAbsence". Package SDMTools must be detached.
}
\author{
M. Iturbide
}
\keyword{internal}
