% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapZmoment.R
\name{morphomapZmoment}
\alias{morphomapZmoment}
\title{morphomapZmoment}
\usage{
morphomapZmoment(cp, mp, Cx = 0, Cy = 0, delta = 0.1)
}
\arguments{
\item{cp}{matrix: coordinates of the external outline of the section}

\item{mp}{matrix: coordinates of the internal outline of the section}

\item{Cx}{numeric: x coordinate of the section center}

\item{Cy}{numeric: y coordinate of the section center}

\item{delta}{numeric: picture elements of adjustable side length}
}
\value{
Zx numeric: moment of inertia around the x axis

Zy numeric: moment of inertia around the y axis

dx numeric: maximum chord length from y axis

dy numeric: maximum chord length from x axis

Zpol numeric: polar moment of inertia
}
\description{
Calculate the polar moment of inertia around the x and y axes and the polar section module
}
\examples{
extsec<-morphomapCircle(10,1000)
intsec<-morphomapCircle(8,1000)
ZMs<-morphomapZmoment(extsec,intsec,delta=0.1)
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
