% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.survData.R
\name{plot.survData}
\alias{plot.survData}
\title{Plotting method for \code{survData} objects}
\usage{
\method{plot}{survData}(x, xlab, ylab = "Number of surviving individuals",
  main = NULL, target.time = NULL, concentration = NULL,
  style = "generic", pool.replicate = FALSE, log.scale = FALSE,
  addlegend = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{survData}}

\item{xlab}{a title for the \eqn{x}-axis (optional)}

\item{ylab}{a label for the \eqn{y}-axis}

\item{main}{main title for the plot}

\item{target.time}{a numeric value corresponding to some observed time in \code{data}}

\item{concentration}{a numeric value corresponding to some concentration in \code{data}}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{pool.replicate}{if \code{TRUE}, the datapoints of each replicate are
summed for a same concentration}

\item{log.scale}{if \code{TRUE}, displays \eqn{x}-axis in log scale}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\description{
Plots the number of survivors as a
function of either time and concentration, time only (for a fixed
concentration), concentration only (for a given target time). If both
concentration and target time are fixed, the function additionally plots
the experimental values for the minimum available concentration.
}
\note{
When \code{style = "ggplot"}, the function calls package
\code{\link[ggplot2]{ggplot2}} and returns an object of class \code{ggplot}.
}
\examples{
library(ggplot2)

# (1) Load the data
data(zinc)
zinc <- survData(zinc)

# (2) Plot survival data
plot(zinc, addlegend = TRUE)

# (3) Plot survival data with a ggplot style
plot(zinc, style = "ggplot")

# (4) To build a specific legend with a ggplot type
fu <- plot(zinc, style = "ggplot", addlegend = FALSE)
fu + theme(legend.position = "left") + scale_colour_hue("Replicate")

# (5) Plot survival data for a fixed concentration and
# target.time with ggplot style
plot(zinc, style = "ggplot", target.time = 21, concentration = 0.66)
}
\keyword{plot}

