% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survFit.R
\name{survFit}
\alias{survFit}
\title{Fits a TKTD model for survival analysis using Bayesian inference}
\usage{
survFit(
  data,
  model_type,
  quiet,
  n.chains,
  n.adapt,
  n.iter,
  n.warmup,
  thin.interval,
  limit.sampling,
  dic.compute,
  dic.type,
  hb_value,
  hb_valueFIXED,
  ...
)
}
\arguments{
\item{data}{an object used to select a method 'survFit'}

\item{model_type}{can be \code{"SD"} or \code{"IT"} to choose
between "Stochastic Death" or "Individual Tolerance" models
(resp.). See the modeling vignette for details.}

\item{quiet}{If \code{FALSE}, prints logs and progress bar from
JAGS.}

\item{n.chains}{A positive integer specifying the number of MCMC chains. The minimum required number 
of chains is 2.}

\item{n.adapt}{A positive integer specifying the number of iterations for adaptation. If \code{n.adapt} = 0
then no adaptation takes place.}

\item{n.iter}{A positive integer specifying the number of iterations to monitor for each chain.}

\item{n.warmup}{A positive integer specifying the number of warmup (aka burnin) iterations per chain.}

\item{thin.interval}{A positive integer specifying the period to monitor.}

\item{limit.sampling}{if \code{FALSE} (default is \code{TRUE}), there is no limit to the number of iterations
in MCMC imposed by the \code{raftery.diag} test.}

\item{dic.compute}{if \code{TRUE} (default is \code{FALSE}), it generates penalized deviance samples to compute
the Deviance Information Criterion (DIC) with the \code{rjags} package}

\item{dic.type}{type of penalty to use. A string identifying the type of penalty: \code{pD} or \code{popt}
(see function \code{\link[rjags]{dic.samples}})}

\item{hb_value}{If \code{TRUE}, the background mortality \code{hb} is taken into account.
If \code{FALSE}, parameter \code{hb} is set to a fixed value defined by \code{hb_valueFIXED}. The default is \code{TRUE}.}

\item{hb_valueFIXED}{If \code{hb_value} is \code{FALSE}, the argument \code{hb_valueFIXED}
provides the values of parameter hb. Default is 0.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This function estimates the parameters of a TKTD model ('SD' or 'IT')
for survival analysis using Bayesian inference. In this model,
the survival rate of individuals is modeled as a function of the chemical compound
concentration with a mechanistic description of the effects on survival over
time.
}
\details{
The function \code{survFit} return the parameter estimates of Toxicokinetic-toxicodynamic (TKTD) models
\code{SD} for 'Stochastic Death' or \code{IT} fo 'Individual Tolerance'.
TKTD models, and particularly the General Unified Threshold model of
Survival (GUTS), provide a consistent process-based
framework to analyse both time and concentration dependent datasets.
In GUTS-SD, all organisms are assumed to have the same internal concentration 
threshold (denoted \eqn{z}), and, once exceeded, the instantaneous probability
to die increases linearly with the internal concentration.
In GUTS-IT, the threshold concentration is distributed among all the organisms, and once 
exceeded in one individual, this individual dies immediately.


When class of \code{object} is \code{survDataCstExp}, see \link[=survFit.survDataCstExp]{survFit.survDataCstExp} ;
and for a \code{survDataVarExp}, see \link[=survFit.survDataVarExp]{survFit.survDataVarExp}.
}
\examples{

# (1) Load the survival data
data(propiconazole)

# (2) Create an object of class "survData"
dataset  <- survData(propiconazole)

\dontrun{
# (3) Run the survFit function with TKTD model 'SD' or 'IT' 
out <- survFit(dataset , model_type = "SD")

# (4) Summarize look the estimated parameters
summary(out)

# (5) Plot the fitted curve
plot(out, adddata = TRUE)

# (6) Plot the fitted curve with ggplot style and CI as spaghetti
plot(out, spaghetti = TRUE , adddata = TRUE)
}

# When the data set include variable exposure profile, time for inference is longer

# (1) Load the survival data with variable exposure profile
data("propiconazole_pulse_exposure")

# (2) Create an object of class "survData"
dataset <- survData(propiconazole_pulse_exposure)

\dontrun{
# (3) Run the survFit function with TKTD model 'SD' or 'IT' 
out <- survFit(dataset , model_type = "SD")

# (4) Summarize look the estimated parameters
summary(out)

# (5) Plot the fitted curve
plot(out, adddata = FALSE)

# (6) Plot the fitted curve with ggplot style and CI as spaghetti
plot(out, spaghetti = TRUE)
}


}
