% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/groupwiseModels.R
\name{gwm}
\alias{gwm}
\title{Groupwise models}
\usage{
gwm(formula, data = parent.frame(), drop = FALSE, ...)
}
\arguments{
\item{formula}{A formula.  The left-hand side specifies the response variable
over which the mean or proportion will be taken.  The right-hand side gives
the explanatory variables, separated by \code{+}.  Means or proportions are
computed for every combination of the levels of the explanatory variables.}

\item{data}{A data frame in which to evaluate variables in \code{formula}.
If omitted, refer.  If not specified, variables
will be taken from the current environment.}

\item{drop}{Logical flag indicating whether to drop unoccupied groups.
Default \code{FALSE}.  NOT YET IMPLEMENTED.}

\item{\dots}{Additional arguments; currently ignored.}
}
\value{
\code{mm} returns an object of class \code{groupwiseModel}.  The functions
\code{fitted.values}, \code{residuals}, \code{coefficients}, and \code{summary}
are useful for extracting various features of the value returned by \code{mm}
}
\description{
Construct a model based on groupwise means or proportions
}
\details{
\code{gwm} (groupwise model) is a sort of training function for
\code{lm}, meant to provide a basis for discussing inference and introducing
resampling in a simple, intuitive setting
of groupwise means or proportions.  \code{lm} provides a better, more general facility.
When using \code{lm} to recreate the results of \code{gwm}, include all the
interaction terms (i.e., use \code{*} instead of \code{+}) and remove the
intercept term.  See the examples.
}
\examples{
gwm( wage ~ sex, data=CPS85 )
gwm( wage ~ sex + married, data = CPS85 )
# The same model, fit using lm() instead
lm( wage ~ sex * married - 1, data = CPS85)
do(5) * gwm( wage ~ sex + married, data = resample(CPS85))
mod <- gwm( width ~ domhand, data=KidsFeet)
summary(mod)
resid(mod)
fitted(mod)
}
\seealso{
\code{\link{lm}},
\code{\link{do}}
}

