% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustering.R
\name{fortify.hclust}
\alias{fortify.hclust}
\alias{mplot.hclust}
\title{mosaic tools for clustering}
\usage{
\method{fortify}{hclust}(model, data, which = c("segments", "heatmap",
  "leaves", "labels", "data"), k = 1, ...)

\method{mplot}{hclust}(object, data, colorize = TRUE, k = 1,
  labels = FALSE, heatmap = 0, enumerate = "white", ...)
}
\arguments{
\item{model}{a model}

\item{data}{a data-like object}

\item{which}{which kind of fortification to compute}

\item{k}{number of clusters}

\item{...}{additional arguments passed on to \code{link{dendro_data}}}

\item{object}{an object of class \code{"hclust"}}

\item{colorize}{whether to show clusters in different colors}

\item{labels}{a logical indicating whether labels should be used
to identify leaves of the tree.}

\item{heatmap}{the ratio of size of heatmap to size of dendrogram.
Use \code{0} or \code{FALSE} to omit the heatmap.}

\item{enumerate}{a color used for numbers within heatmap.  Use 
\code{"transparent"} to hide.}
}
\description{
mosaic tools for clustering
}
\examples{
if (require(mosaicData)) {
KidsFeet \%>\% select(-name, -birthmonth) \%>\% rescale() -> KidsFeet2
  M <- dist(KidsFeet2)
  Cl <- hclust(M)
  fortify(Cl, k=5) \%>\% head(3)
  fortify(Cl, which="heatmap", data=KidsFeet2) \%>\% head(3)
  fortify(Cl, which="data", data=KidsFeet2) \%>\% head(3)
  fortify(Cl, which="labels") \%>\% head(3)
  mplot(Cl, data=KidsFeet2, k=4, heatmap=2)
  mplot(Cl, data=KidsFeet2, k=4, heatmap=0.5, enumerate="transparent")
  mplot(Cl, data=KidsFeet2, k=4, heatmap=2, type="triangle")
  mplot(Cl, data=KidsFeet2, k=4, heatmap=0, type="triangle")
}
}

