% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregatingAux.R
\name{maggregate}
\alias{maggregate}
\title{Aggregate for mosaic}
\usage{
maggregate(formula, data = parent.frame(), FUN, groups = NULL, subset,
  drop = FALSE, ..., .format = c("default", "table", "flat"),
  .overall = mosaic.par.get("aggregate.overall"), .multiple = FALSE,
  .name = deparse(substitute(FUN)), .envir = parent.frame())
}
\arguments{
\item{formula}{a formula.  Left side provides variable to be summarized.  Right side and condition
describe subsets.  If the left side is empty, right side and condition are
shifted over as a convenience.}

\item{data}{a data frame.
Note that the default is \code{data=parent.frame()}.  This makes it convenient to
use this function interactively by treating the working envionment as if it were
a data frame.  But this may not be appropriate for programming uses.
When programming, it is best to use an explicit \code{data} argument
-- ideally supplying a data frame that contains the variables mentioned
in \code{formula}.}

\item{FUN}{a function to apply to each subset}

\item{groups}{grouping variable that will be folded into the formula (if there is room for it).
This offers some additional flexibility in how formulas can be specified.}

\item{subset}{a logical indicating a subset of \code{data} to be processed.}

\item{drop}{a logical indicating whether unused levels should be dropped.}

\item{\dots}{additional arguments passed to \code{FUN}}

\item{.format}{format used for aggregation. \code{"default"} and \code{"flat"} are equivalent.}

\item{.overall}{currently unused}

\item{.multiple}{a logical indicating whether FUN returns multiple values
Ignored if \code{.multiple} is not \code{NULL}.}

\item{.name}{a name used for the resulting object}

\item{.envir}{an environment in which to evaluate expressions}
}
\value{
a vector
}
\description{
Compute function on subsets of a variable in a data frame.
}
\examples{
if (require(mosaicData)) {
maggregate( cesd ~ sex, HELPrct, FUN=mean )
# using groups instead
maggregate( ~ cesd, groups = sex, HELPrct, FUN=sd )
# the next four all do the same thing
maggregate( cesd ~ sex + homeless, HELPrct, FUN=mean )
maggregate( cesd ~ sex | homeless, HELPrct, FUN=sd )
maggregate( ~ cesd | sex , groups= homeless, HELPrct, FUN=sd )
maggregate( cesd ~ sex, groups = homeless, HELPrct, FUN=sd )
# this is unusual, but also works.
maggregate( cesd ~ NULL , groups = sex, HELPrct, FUN=sd )
}

}
