% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgeo.R
\name{rlatlon}
\alias{rlatlon}
\alias{rlonlat}
\alias{rgeo}
\alias{rgeo2}
\title{Sample longitude and latitude on a sphere}
\usage{
rlatlon(...)

rlonlat(...)

rgeo(n = 1, latlim = c(-90, 90), lonlim = c(-180, 180), verbose = FALSE)

rgeo2(n = 1, latlim = c(-90, 90), lonlim = c(-180, 180),
  verbose = FALSE)
}
\arguments{
\item{...}{arguments passed through to other functions}

\item{n}{number of random locations}

\item{latlim, lonlim}{range of latitudes and longitudes to sample within, only implemented for \code{rgeo}.}

\item{verbose}{return verbose output that includes Euclidean coordinates on unit sphere as well as
longitude and latitude.}
}
\value{
a data frame with variables \code{long} and \code{lat}.  If \code{verbose} is
TRUE, then x, y, and z coordinates are also included in the data frame.
}
\description{
Randomly samples longitude and latitude on earth so that equal areas are
(approximately) equally likely to be sampled.
(Approximation assumes earth as a perfect sphere.)
}
\details{
\code{rgeo} and \code{rgeo2} differ in the algorithms used to generate random positions.
Each assumes a spherical globe.  \code{rgeo} uses that fact that each of the x, y and z
coordinates is uniformly distributed (but not independent of each other).  Furthermore, the
angle about the z-axis is uniformly distributed and independent of z.  This provides
a straightforward way to generate Euclidean coordinates using \code{runif}.  These are then
translated into latitude and longitude.

\code{rlatlon} is an alias for \code{rgeo} and
\code{rlonlat} is too, expect that it reverses the
order in which the lattitude and longitute values are
returned.

\code{rgeo2} samples points in a cube by independently sampling each coordinate.  It then
discards any point outside the sphere contained in the cube and projects the non-discarded points
to the sphere.  This method must oversample to allow for the discarded points.
}
\examples{
rgeo(4)
# sample from a region that contains the continental US
rgeo( 4, latlim=c(25,50), lonlim=c(-65,-125) )
rgeo2(4)
}
\seealso{
\code{\link[=deg2rad]{deg2rad()}}, \code{\link[=googleMap]{googleMap()}} and \code{\link[=latlon2xyz]{latlon2xyz()}}.
}
\keyword{geometry}
\keyword{map}
\keyword{random}
