% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zscore.R
\name{zscore}
\alias{zscore}
\title{Compute z-scores}
\usage{
zscore(x, na.rm = getOption("na.rm", FALSE))
}
\arguments{
\item{x}{a numeric vector}

\item{na.rm}{a logical indicating whether missing values should be removed}
}
\description{
Compute z-scores
}
\examples{
data(penguins, package = "palmerpenguins")
penguins \%>\% 
  group_by(species) \%>\% 
  mutate(zbill_length_mm = zscore(bill_length_mm, na.rm = TRUE)) \%>\% 
  head()
}
