% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIsim.R
\name{CIsim}
\alias{CIsim}
\title{Compute confidence intervals from (multiple) simulated data sets}
\usage{
CIsim(
  n,
  samples = 100,
  rdist = rnorm,
  args = list(),
  plot = if (samples <= 200) "draw" else "none",
  estimand = 0,
  conf.level = 0.95,
  method = t.test,
  method.args = list(),
  interval = function(x) {
     do.call(method, c(list(x, conf.level = conf.level),
    method.args))$conf.int
 },
  estimate = function(x) {
     do.call(method, c(list(x, conf.level = conf.level),
    method.args))$estimate
 },
  verbose = TRUE
)
}
\arguments{
\item{n}{size of each sample}

\item{samples}{number of samples to simulate}

\item{rdist}{function used to draw random samples}

\item{args}{arguments required by \code{rdist}}

\item{plot}{one of \code{"print"}, \code{"return"}, \code{"horizontal"}, or \code{"none"}
describing whether a plot should be printed, returned, printed with horizontal intervals,
or not generated at all.}

\item{estimand}{true value of the parameter being estimated}

\item{conf.level}{confidence level for intervals}

\item{method}{function used to compute intervals.  Standard functions that
produce an object of class \code{htest} can be used here.}

\item{method.args}{arguments required by \code{method}}

\item{interval}{a function that computes a confidence interval from data.  Function
should return a vector of length 2.}

\item{estimate}{a function that computes an estimate from data}

\item{verbose}{print summary to screen?}
}
\value{
A data frame with variables
\code{lower},
\code{upper},
\code{estimate},
\code{cover} ('Yes' or 'No'),
and
\code{sample}
is returned invisibly.  See the examples for a way to use this to display the intervals
graphically.
}
\description{
This function automates the calculation of coverage rates for exploring
the robustness of confidence interval methods.
}
\examples{
# 1000 95\% intervals using t.test; population is N(0,1)
CIsim(n = 10, samples = 1000)    
# this time population is Exp(1); fewer samples, so we get a plot 
CIsim(n = 10, samples = 100, rdist = rexp, estimand = 1) 
# Binomial treats 1 like success, 0 like failure
CIsim(n = 30, samples = 100, rdist = rbinom, args = list(size = 1, prob = .7), 
       estimand = .7, method = binom.test, method.args = list(ci = "Plus4"))  

}
\keyword{inference}
\keyword{simulation}
