% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{mutUniformMetaReset}
\alias{mutUniformMetaReset}
\title{Parametrised Uniform Reset for Binary Parameters}
\usage{
mutUniformMetaReset(ind, p = 0.1, reset.dists, reset.dist.weights)
}
\arguments{
\item{ind}{\verb{[integer]} binary individual with values 0 or 1.}

\item{p}{\verb{[numeric(1)]} entry-wise reset probability.}

\item{reset.dists}{\verb{[matrix]} columns of probabilities to draw 1-bit per entry, if reset is performed.
Must have \code{length(ind)} rows and \code{length(reset.dist.weights)} columns.}

\item{reset.dist.weights}{\verb{[numeric]} weight vector to select among \code{reset.dists} columns.}
}
\value{
\verb{[integer]} the mutated individual
}
\description{
Performs \code{\link{mutUniformReset}} with \code{reset.dist = reset.dists \%*\% reset.dist.weights}.
}
