% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosum.R
\name{plot.mosum.cpts}
\alias{plot.mosum.cpts}
\title{Plotting the output from MOSUM procedure}
\usage{
\method{plot}{mosum.cpts}(
  x,
  display = c("data", "mosum")[1],
  cpts.col = "red",
  critical.value.col = "blue",
  xlab = "Time",
  ...
)
}
\arguments{
\item{x}{a \code{mosum.cpts} object}

\item{display}{which to be plotted against the change point estimators; possible values are
\itemize{
   \item{\code{"data"}}{input time series is plotted along with the estimated piecewise constant signal}
   \item{\code{"mosum"}}{scaled MOSUM detector values are plotted}
}}

\item{cpts.col}{a specification for the color of the vertical lines at
the change point estimators, see \link[graphics]{par}}

\item{critical.value.col}{a specification for the color of the horizontal line
indicating the critical value, see \link[graphics]{par}; use iff \code{display = "mosum"}}

\item{xlab}{graphical parameter}

\item{...}{additional graphical arguments, see \link[graphics]{plot}
and \link[graphics]{abline}}
}
\description{
Plotting method for S3 objects of class \code{mosum.cpts}
}
\details{
The location of each change point estimator is plotted as a vertical line
against the input time series and the estimated piecewise constant signal (\code{display = "data"})
or MOSUM detector values (\code{display = "mosum"}).
}
\examples{
x <- testData(lengths = rep(100, 3), means = c(0, 5, -2), sds = rep(1, 3), seed = 1234)$x
m <- mosum(x, G = 40)
par(mfrow = c(2, 1), mar = c(2.5, 2.5, 2.5, .5))
plot(m, display = "data")
plot(m, display = "mosum")
}
