% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_count}
\alias{mt_count}
\title{Count number of observations.}
\usage{
mt_count(data, use = "trajectories", save_as = "measures",
  dimensions = "xpos")
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the resulting trajectory
data should be stored.}

\item{dimensions}{a character vector specifying the name of the dimension(s)
that should be used for counting the number of observations. If several
dimensions are specified, the number of complete observations are reported.}
}
\value{
A mousetrap data object (see \link{mt_example}).
  
  If a data.frame with label specified in \code{save_as} (by default 
  "measures") already exists, the number of obervations (called \code{nobs})
  are added as additional column. If not, an additional \link{data.frame}
  will be added.
  
  If a trajectory array was provided directly as \code{data}, only a named
  character vector will be returned.
}
\description{
Count number of observations per trial for a specified dimension (or several)
in the trajectory array. This is mostly a helper function used by other
functions in this package.
}
\examples{
# Retrieve vector that counts number of observations
mt_count(mt_example$trajectories)

}
\author{
Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})
}
