% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialize.R
\name{mt_length_normalize}
\alias{mt_length_normalize}
\title{Length normalize trajectories.}
\usage{
mt_length_normalize(
  data,
  use = "trajectories",
  dimensions = c("xpos", "ypos"),
  save_as = "ln_trajectories",
  n_points = 20
)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{dimensions}{a character string specifying which trajectory variables 
should be used. Can be of length 2 or 3 for two-dimensional or 
three-dimensional data.}

\item{save_as}{a character string specifying where the resulting trajectory
data should be stored.}

\item{n_points}{an integer or vector of integers specifying the number of 
points used to represent the spatially rescaled trajectories. If a single 
integer is provided, the number of points will be constant across 
trajectories. Alternatively, a vector of integers can provided that specify
the number of points for each trajectory individually.}
}
\value{
A mousetrap data object (see \link{mt_example}) with an additional
  array (by default called \code{ln_trajectories}) containing the length
  normalized trajectories. If a trajectory array was provided directly as
  \code{data}, only the length normalized trajectories will be returned.
}
\description{
Re-represent each trajectory spatially using a constant number of points so 
that adjacent points on the trajectory become equidistant to each other.
}
\details{
\code{mt_length_normalize} is used to emphasize the trajectories' shape.
Usually, the vast majority of points of a raw or a time-normalized trajectory
lie close to the start and end point. \code{mt_length_normalize}
re-distributes these points so that the spatial distribution is uniform
across the entire trajectory. \code{mt_length_normalize} is mainly used to
improve the results of clustering (in particular \link{mt_cluster}) and
visualization.
}
\examples{
KH2017 <- mt_length_normalize(data=KH2017,
  dimensions = c('xpos','ypos'),
  n_points = 20)

}
\author{
Dirk U. Wulff

Jonas M. B. Haslbeck
}
