% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_raster.R
\name{animate_raster}
\alias{animate_raster}
\title{Animate raster data}
\usage{
animate_raster(layer, out_dir, conv_dir = "convert",
  layer_type = "gradient", layer_stretch = "none",
  layer_col = c("sandybrown", "white", "darkgreen"), layer_nacol = "white",
  static_data = NA, static_gg = NA, img_title = "title",
  img_sub = "subtitle", img_caption = "caption", img_labs = "labs",
  legend_title = "", legend_limits = NA, legend_labels = "auto",
  map_elements = TRUE, scalebar_col = "white", north_col = "white",
  frames_nmax = 0, frames_interval = 0.04, frames_nres = 1,
  frames_width = NA, frames_height = NA, out_name = "final_gif",
  log_level = 1, log_logical = FALSE, ...)
}
\arguments{
\item{layer}{list. List of raster objects.}

\item{out_dir}{character. Output directory for the GIF file creation.}

\item{conv_dir}{character. Command or directory to call the ImageMagick convert tool (default to be \code{convert}). You can use \code{conv_dir = get_imconvert()} to search for the right command/tool directory and/or get the required software.}

\item{layer_type}{charachter. Layer type. Can be either "\code{RGB}" (if layer is a rasterBrick class object), "\code{gradient}" or "\code{discrete}". Default is "\code{gradient}".}

\item{layer_stretch}{character. Ignored, if \code{layer_type} is not "RGB". Either "none", "lin", "hist", "sqrt" or "log" for no stretch, linear, histogram, square-root or logarithmic stretch. Default is "none".}

\item{layer_col}{character vector.  Two or more colours to be used for displaying the background layer. If \code{layer_type = "gradient"}, a colour ramp between the colous is calcualted. If \code{layer_type = "discrete"}, the colours will be used per value range. Ignored, if \code{layer_type = "RGB"}.}

\item{layer_nacol}{character. Colour to be displayed for NA values. Default is "white".}

\item{static_data}{data.frame. Data (e.g. static points) to be displayed within the spatial plot of the GIF output. At least, "x", "y" columns for the coordinates and "names" for the naming of the point have to be included. If "static_gg" remains unspecified, "static_data" is plottet as points to the output map, annotated with their namings. Points outside the frame extent are not displayed. See "static_gg" for further options.}

\item{static_gg}{character. One or several \code{ggplot2} functions, concatenated by "+" specifying how "static_data" should be displayed, e.g. using \code{geom_point} and \code{geom_text} for displaying points annotated with text. \code{ggplot2 data} and \code{aes, aes_} arguments etc. need to referr to the columns specified in "static_data". As default, "static_data" is plotted as \code{geom_point} and \code{geom_label}.}

\item{img_title}{character. Titel to be displayed above the animated plot. If not specified, no title will be displayed.}

\item{img_sub}{character. Subtitel to be displayed underneath the title. If not specified, no subtitle will be displayed.}

\item{img_caption}{character. Caption to be displayed underneath the plot. If not specified, no caption will be displayed.}

\item{img_labs}{character. Axis titles to be displayed at the x and y axis of the plot. If not specified, labs will be computed depending on the projection or will be "x" and "y".}

\item{legend_title}{character. Title to be displayed above the basemap layer legend (if layer_type is not \code{"RGB"}). Ignored, if \code{layer = "basemap"}.}

\item{legend_limits}{numeric vector. Fixed minimum and maximum limit values of the legend (gradient layer type). Default is NA for data-depending minimum and maximum values. Ignored, if \code{layer_type} is "discrete" or "RGB".}

\item{legend_labels}{character vectors. Label for each legend break class. If set to "auto", values are displayed. Default is "auto".}

\item{map_elements}{logical. If \code{FALSE}, map elements (north arrow and scale bar) are hidden. Default is \code{TRUE}.}

\item{scalebar_col}{character. Colour of the scalebar text. Default is "white".}

\item{north_col}{character. Colour of the north arrow. Default is "white".}

\item{frames_nmax}{numeric. Number of maximum frames. If set, the animation will be stopped, after the specified number of frames is reached. Default is 0 (displaying all frames).}

\item{frames_interval}{numeric. Duration, each frame is displayed (in seconds). Default is .04.}

\item{frames_nres}{numeric. Interval of which frames of all frames should be used (nth elements). Default is 1 (every frame is used). If set to 2, only every second frame is used.}

\item{frames_width}{numeric. Number of pixels of frame width. Default is 600 (with stats plots 1000).}

\item{frames_height}{numeric. Number of pixels of frame height. Defualt is 600.}

\item{out_name}{character. Name of the output file. Default is "final_gif".}

\item{log_level}{numeric. Level of console output given by the function. There are three log levels. If set to 3, no messages will be displayed except erros that caused an abortion of the process. If set to 2, warnings and errors will be displayed. If set to 1, a log showing the process activity, wanrnings ans errors will be displayed.}

\item{log_logical}{logical. For large processing schemes. If \code{TRUE}, the function returns \code{TRUE} when finished processing succesfully.}

\item{...}{optional arguments.}
}
\value{
None or logical (see \code{log_logical}). The output GIF file is written to the ouput directory.
}
\description{
\code{animate_raster} animates raster data provided as list of \code{raster} class objects. The function creates an animated GIF file and saves it into the output directory.
}
\details{
\code{animate_raster} is partly based on the \code{animation} package and needs the \code{convert} tool of the \code{ImageMagick} software package to assemble the GIF file. The command or directory to the convert tool needs to be provided with \code{conv_dir}. Please use \code{\link{get_imconvert}} to search for the convert command/tool directory on your system or to automatically download and install the required software. See \code{\link{get_imconvert}} for details.
}
\examples{
\dontrun{
#Create a list of several raster objects to be displayed one after another
#If layer_type = RGB, use a brick class obejct with RGB bands!
layer <- list(raster1, raster2, raster2)

#Get your convert directory/command
conv_dir <- get_imconvert()

#Specify the output directory, e.g.
out_dir <- "/out/test"
#or to a temporary directory:
out_dir <- paste0(tempdir(),"/test")
dir.create(out_dir)

#Call animate_raster
animate_raster(layer,out_dir = our_dir, conv_dir = conv_dir, layer_type = "RGB")
}

}
\seealso{
\code{\link{get_imconvert}}
}
\author{
Jakob Schwalb-Willmann
}
