% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{splice_time.View}
\alias{splice_time.View}
\title{Generate spliced timeline using a view}
\usage{
\method{splice_time}{View}(x, win_size, step_size, ...)
}
\arguments{
\item{x}{\code{View} object.}

\item{win_size}{duration of window segment in seconds.}

\item{step_size}{increment in seconds between segments.}

\item{...}{ignored.}
}
\value{
a \code{Splice} object.
}
\description{
Generate spliced timeline using a view
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
df <- splice_time(rv, win_size = 3, step_size = 0.5)
head(df)
}
\seealso{
Other splicing functions: 
\code{\link{clip_splice}()},
\code{\link{get_spliced_view}()},
\code{\link{is_splice_overlapping}()},
\code{\link{merge_splice}()},
\code{\link{splice_time.Duration}()},
\code{\link{splice_time.Metre}()},
\code{\link{splice_time.OnsetsDifference}()},
\code{\link{splice_time.list}()},
\code{\link{splice_time}()},
\code{\link{split.SplicedView}()}
}
\concept{splicing functions}
