% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_pactr-accessors.R
\name{get_similar_ions}
\alias{get_similar_ions}
\title{Get similar ion groups.}
\usage{
get_similar_ions(mpactr_object)
}
\arguments{
\item{mpactr_object}{The mpactr object that is created by calling the
import_data() function.}
}
\value{
a \code{data.table} reporting the main ion and those found to be
similar with \code{\link[=filter_mispicked_ions]{filter_mispicked_ions()}}.
}
\description{
\code{get_similar_ions()} is a wrapper function to return similar ion groups
determined with the \code{\link[=filter_mispicked_ions]{filter_mispicked_ions()}}.
}
\examples{
data <- import_data(
  example_path("coculture_peak_table.csv"),
  example_path("metadata.csv"),
  format = "Progenesis"
)

data_filter <- filter_mispicked_ions(data)

mispicked_ion_groups <- get_similar_ions(data_filter)
mispicked_ion_groups

}
