% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{get_app_usage}
\alias{get_app_usage}
\title{Get app usage per hour}
\usage{
get_app_usage(
  db,
  participant_id = NULL,
  start_date = NULL,
  end_date = NULL,
  by = c("Total", "Day", "Hour")
)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}

\item{start_date}{Optional search window specifying date where to begin search. Must be
convertible to date using \link[base]{as.Date}. Use \link[mpathsenser]{first_date} to find the
date of the first entry for a participant.}

\item{end_date}{Optional search window specifying date where to end search. Must be convertible
to date using \link[base]{as.Date}. Use \link[mpathsenser]{last_date} to find the date of the
last entry for a participant.}

\item{by}{Either 'Total', 'Hour', or 'Day' indicating how to summarise the results.}
}
\value{
A data frame containing a column 'app' and a column 'usage' for the hourly app usage.
}
\description{
This function extracts app usage per hour for either one or multiple participants. If multiple
days are selected, the app usage time is averaged.
}
