% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{test_jsons}
\alias{test_jsons}
\title{Test JSON files for being in the correct format.}
\usage{
test_jsons(path = getwd(), files = NULL, db = NULL, recursive = TRUE)
}
\arguments{
\item{path}{The path name of the JSON files.}

\item{files}{Alternatively, a character list of the input files.}

\item{db}{A mpathsenser database connection (optional). If provided, will be used to check which
files are already in the database and check only those JSON files which are not.}

\item{recursive}{Should the listing recurse into directories?}
}
\value{
A message indicating whether there were any issues and a character vector of the file
names that need to be fixed. If there were no issues, an invisible empty string is returned.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\section{Parallel}{
 This function supports parallel processing in the sense that it is able to
distribute it's computation load among multiple workers. To make use of this functionality, run
\href{https://rdrr.io/cran/future/man/plan.html}{\code{future::plan("multisession")}} before
calling this function.
}

\section{Progress}{
 You can be updated of the progress of this function by using the
\code{\link[progressr:progress]{progressr::progress()}} package. See \code{progressr}'s
\href{https://cran.r-project.org/package=progressr/vignettes/progressr-intro.html}{vignette} on
how to subscribe to these updates.
}

\examples{
\dontrun{
# Test all files in a directory
test_jsons(path = "path/to/jsons", recursive = FALSE)

# Test all files in a directory and its subdirectories
test_jsons(path = "path/to/jsons", recursive = TRUE)

# Test specific files
test_jsons(files = c("file1.json", "file2.json"))

# Test files in a directory, but skip those that are already in the database
test_jsons(path = "path/to/jsons", db = db)
}
}
