% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpcmp-package.R
\docType{data}
\name{takeoverbids}
\alias{takeoverbids}
\title{Takeover Bids data set}
\format{A data frame with 126 observations on 14 variables.
\describe{
\item{bidprem}{bid price divided by price 14 working days before bid}
\item{docno}{doc no}
\item{finrest}{indicator variable for proposed change in ownership structure}
\item{insthold}{percentage of stock held by institutions}
\item{leglrest}{indicator variable for legal defence by lawsuit}
\item{numbids}{number of bids recevied after the initial bid}
\item{obs}{Identifier}
\item{rearest}{indicator variable for proposed changes in asset structure}
\item{regulatn}{indicator variable for Department of Justice intervention}
\item{size}{total book value of assets in billions of dollars}
\item{takeover}{Indicator. 1 if the company was being taken over}
\item{weeks}{time in weeks between the initial and final offers}
\item{whtknght}{indicator varible for management invitation 
for friendly third-party bid}
\item{sizesq}{book value squared}
}}
\source{
Journal of Applied Econometrics data archive: \url{http://qed.econ.queensu.ca/jae/}.
}
\usage{
data(takeoverbids)
}
\description{
This data set gives the number of bids received by 126 US firms that were successful
targets of tender offers during the period 1978--1985, along with some explanatory 
variables on the defensive actions taken by management of target firm, firm-specific
characteristics and intervention taken by federal regulators. The \code{takeoverbids} 
data frame has 126 observations on 14 variables. The descriptions below are taken from
 Sáez-Castillo and Conde-Sánchez (2013).
}
\examples{
## For examples see example(glm.cmp)
}
\references{
Cameron, A.C. and Johansson, P. (1997). Count Data Regression Models using Series 
Expansions: with Applications. \emph{Journal of Applied Econometrics} \bold{12} 203--223.

Cameron, A.C. and Trivedi P.K. (1998). Regression analysis of count data, Cambridge University Press, \url{http://cameron.econ.ucdavis.edu/racd/racddata.html} chapter 5.

Croissant Y (2011) Ecdat: Datasets for econometrics, R Package, version 0.1–6.1.

Jaggia, S. and Thosar, S. (1993). Multiple Bids as a Consequence of Target Management
Resistance \emph{Review of Quantitative Finance and Accounting} \bold{3}, 447--457.
}
\keyword{datasets}
