% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.QTLprof.R
\name{plot.QTLprof}
\alias{plot.QTLprof}
\title{plot QTL profile}
\usage{
\method{plot}{QTLprof}(x, gen.eff = FALSE, mppData, Q.eff, QTL = NULL,
  type = "l", main = "QTL profile", threshold = 3, text.size = 18,
  ...)
}
\arguments{
\item{x}{Object of class \code{QTLprof} returned by the function
\code{\link{mpp_SIM}} or \code{\link{mpp_CIM}}.}

\item{gen.eff}{\code{Logical}. Specify the type of plot.
If \code{gen.eff = FALSE}, standard QTL profile. If \code{gen.eff = TRUE},
genome-wide genetic effect plot. In that case, the \code{QTLprof} object in
\code{x} must have been calculated with argument \code{plot.gen.eff = TRUE}.
Default = FALSE.}

\item{mppData}{An object of class \code{mppData}. Only required if
\code{gen.eff = TRUE}.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effects: 1) "cr" for cross-specific; 2) "par" for parental
effects; 3) "anc" for ancestral effects. Only required if
\code{gen.eff = TRUE}}

\item{QTL}{Optional argument. List of QTL positions. Object of class
\code{QTLlist} representing a list of selected position obtained with the
function \code{\link{QTL_select}} or two columns numeric matrix with the
chromosome and the position in cM. These positions will be drawn on the
graph. Default = NULL.}

\item{type}{\code{Character} expression indicating the type of plot should be
drawn: "l" for lines , "h" for vertical bar. Default = "l".}

\item{main}{Title of the graph. Default = "QTL profile".}

\item{threshold}{\code{Numeric} QTL significance threshold value draw on
the plot. Default = 3.}

\item{text.size}{\code{Numeric} value specifying the size of graph axis text
elements. Default = 18.}

\item{...}{Ignored.}
}
\description{
Plots the -log10(p-val) profile of a QTL analysis or a genome-wide
genetic effect plot using package ggplot2.
}
\details{
The user can plot regular QTL profiles (\code{gen.eff = FALSE}) with
-log10(p-val) plotted against genetic position or genome-wide genetic
effects plots (\code{gen.eff = TRUE}). To plot the genome-wide genetic
effects, the SIM and CIM QTL profile must have been computed with
\code{plot.gen.eff = TRUE}.

The genome-wide genetic effects plots is a visualization of the significance
of the QTL effect per cross or per parents along the genome. For a
cross-specific QTL profile (\code{Q.eff = "cr"}): Red color means
that the allele coming from parent A(1) increases the phenotypic value and
parent B(2) decreases it and blue that parent A(1) decreases the trait and
parent B(2) increases it.

For a parental (\code{Q.eff = "par"}) or an ancestral model
(\code{Q.eff = "anc"}), the results are given per parents. The significance
of the effect must be interpreted as a deviation with respect to the
reference of each connected part. The reference allele is always defined as
the most frequent one. Red (Blue) colour means a significant negative
(positive) effect with respect to the reference of the connected part.

The reference parental allele can change at each position according to the
segregation rate. The parent are plotted from the top to the bottom according
to the number of time their allele is set as reference.  Therefore
interpretation of the genetic effect plot should be done with caution.
In that case, the plot should be taken as a rough indication of the signal
distribution.

The colour intensity increase with the significance of the effect.
There are five colour intensities according to the p-value of the QTL
effect: 0.05<p-val<0.01; 0.01<p-val<0.001; 0.001<p-val<0.0001;
0.0001<p-val<0.00001 and p-val< 0.00001.

For both type of plot, the user can pass a list of cofactors or QTL position
to the argument \code{QTL}. These positions will be drawn on the graph using
dotted lines.
}
\examples{

data(mppData)

SIM <- mpp_SIM(mppData = mppData)
QTL <- QTL_select(SIM)
plot(x = SIM, QTL = QTL)

SIM <- mpp_SIM(mppData = mppData, Q.eff = "cr", plot.gen.eff = TRUE)
QTL <- QTL_select(SIM)
plot(x = SIM, gen.eff = TRUE, mppData = mppData, Q.eff = "cr", QTL = QTL)

}
\seealso{
\code{\link{mpp_SIM}}, \code{\link{mpp_CIM}}, \code{\link{QTL_select}}
}
\author{
Vincent Garin
}
