% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MQE_proc.R
\name{MQE_proc}
\alias{MQE_proc}
\title{Multi-QTL effect MPP analysis}
\usage{
MQE_proc(
  pop.name = "MPP_MQE",
  trait.name = "trait1",
  mppData = NULL,
  trait = 1,
  Q.eff,
  ref.par = NULL,
  threshold = 4,
  window = 30,
  backward = TRUE,
  alpha.bk = 0.05,
  plot.MQE = FALSE,
  CI = FALSE,
  drop = 1.5,
  n.cores = 1,
  verbose = TRUE,
  output.loc
)
}
\arguments{
\item{pop.name}{\code{Character} name of the studied population.
Default = "MPP_MQE".}

\item{trait.name}{\code{Character} name of the studied trait.
Default = "trait1".}

\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{Q.eff}{\code{Character} vector of possible QTL effects the user want to
test. Elements of \code{Q.eff} can be "cr", "par", "anc" or "biall".
For details look at \code{\link{mpp_SIM}}.}

\item{ref.par}{Optional \code{Character} expression defining the parental
allele that will be used as reference to calculate the allelic effects of 
the parental model. For the ancestral model, the ancestral class containing
the reference parent will be set as reference. \strong{This option can only
be used if the MPP design is composed of a unique connected part}.
Default = NULL.}

\item{threshold}{\code{Numeric} value representing the -log10(p-value)
threshold above which a position can be considered as significant.
Default = 4.}

\item{window}{\code{Numeric} distance (cM) on the left and the right of a
cofactor position where it is not included in the model. Default = 30.}

\item{backward}{\code{Logical} value. If \code{backward = TRUE},
the function performs
a backward elimination on the list of selected QTLs. Default = TRUE.}

\item{alpha.bk}{\code{Numeric} value indicating the significance level for
the backward elimination. Default = 0.05.}

\item{plot.MQE}{\code{Logical} value. If \code{plot.MQE = TRUE},
the function will plot the last run of the MQE model determination.
Default = FALSE.}

\item{CI}{\code{Logical} value. If \code{CI = TRUE}, the function will
compute a -log10(pval) drop confidence interval for each QTL using
the QTL profile of the last iteration. Default = FALSE.}

\item{drop}{\code{Numeric} -log10(p-value) drop value at the limits of the
interval. Default = 1.5.}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}

\item{verbose}{\code{Logical} value indicating if the steps of MQE_proc should
be printed. Default = TRUE.}

\item{output.loc}{Path where a folder will be created to save the results.}
}
\value{
Return:

\code{List} containing the following items:

\item{n.QTL}{Number of detected QTLs.}

\item{QTL}{\code{Data.frame} with QTL positions.}

\item{R2}{\code{list} containing R squared statistics of the QTL effects.
for details see \code{\link{QTL_R2}}.}

\item{QTL.effects}{\code{List} of genetic effects per QTL.}

\item{QTL.CI}{If \code{CI = TRUE}, confidence interval information of
the QTLs.}


Some output files are also saved at the location specified
(\code{output.loc}):

\enumerate{

\item{A QTL report (QTL_REPORT.txt) with: 1) the number of detected QTLs;
2) the global R squared statistics; 3) for each QTL, position information
 and estimated QTL genetic effect per cross or parents.}

\item{The list of QTLs (QTL.txt).}

\item{The QTL R squared statistics (QTL_R2.txt) (for details see
 \code{\link{QTL_R2}}).}

\item{General results of the QTL detection process: Number of QTL and
global adjusted and non-adjusted R squared statistics. (QTL_genResults.txt).}

\item{if \code{plot.MQE = TRUE}, a plot of the last QTL detection run profile
(plot_MQE.pdf).}

\item{If \code{CI = TRUE}, the QTL confidence intervals (QTL_CI.txt).}

}
}
\description{
Build multi-QTL effects (MQE) models in which different QTL effects
(cross-specific, parental, ancestral or bi-allelic) can be assumed at
different loci.
}
\details{
The possible QTL effect that the user wants to allow must be
specified in \code{Q.eff}. The procedure is the following:

\enumerate{

\item{Forward regression to determine a MQE model with different
possible assumptions for the QTL effect at different loci. The function
use.}

\item{Optional backward elimination (\code{backward = TRUE}) on the final
list of detected QTLs.} 

\item{Estimation of the QTL genetic effects and R squared statistics.}

\item{If \code{plot.MQE = TRUE}, plot of the last CIM run of the
forward regression.}

\item{If \code{CI = TRUE}, confidence interval calculation based on a
CIM- (CIM without cofactor on the selected chromosome) of the last run of the
forward regression.}

}
}
\examples{

data(mppData)

# Specify a location where your results will be saved
my.loc <- tempdir()

MQE <- MQE_proc(pop.name = "USNAM", trait.name = "ULA", mppData = mppData,
                Q.eff = c("par", "biall"), verbose = FALSE,
                output.loc = my.loc)
                 

}
\seealso{
\code{\link{mpp_SIM}}, \code{\link{MQE_gen_effects}}
}
\author{
Vincent Garin
}
