% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{mr.raps}
\alias{mr.raps}
\alias{mr.raps.all}
\alias{mr.raps.simple}
\alias{mr.raps.overdispersed}
\alias{mr.raps.simple.robust}
\alias{mr.raps.overdispersed.robust}
\title{Main function}
\usage{
mr.raps(b_exp, b_out, se_exp, se_out, over.dispersion = FALSE,
  loss.function = c("l2", "huber", "tukey"), diagnosis = FALSE,
  se.method = c("sandwich", "bootstrap"), k = switch(loss.function[1], l2 =
  NULL, huber = 1.345, tukey = 4.685), B = 1000, suppress.warning = FALSE)

mr.raps.all(b_exp, b_out, se_exp, se_out)

mr.raps.simple(b_exp, b_out, se_exp, se_out, diagnosis = FALSE)

mr.raps.overdispersed(b_exp, b_out, se_exp, se_out,
  initialization = c("simple", "mode"), suppress.warning = FALSE,
  diagnosis = FALSE, niter = 20, tol = .Machine$double.eps^0.5)

mr.raps.simple.robust(b_exp, b_out, se_exp, se_out, loss.function = c("huber",
  "tukey"), k = switch(loss.function[1], huber = 1.345, tukey = 4.685),
  diagnosis = FALSE)

mr.raps.overdispersed.robust(b_exp, b_out, se_exp, se_out,
  loss.function = c("huber", "tukey"), k = switch(loss.function[1], huber =
  1.345, tukey = 4.685), initialization = c("l2", "mode"),
  suppress.warning = FALSE, diagnosis = FALSE, niter = 20,
  tol = .Machine$double.eps^0.5)
}
\arguments{
\item{b_exp}{A vector of SNP effects on the exposure variable, usually obtained from a GWAS.}

\item{b_out}{A vector of SNP effects on the outcome variable, usually obtained from a GWAS.}

\item{se_exp}{A vector of standard errors of \code{b_exp}.}

\item{se_out}{A vector of standard errors of \code{b_out}.}

\item{over.dispersion}{Should the model consider overdispersion (systematic pleiotropy)? Default is FALSE.}

\item{loss.function}{Either the squared error loss (\code{l2}) or robust loss functions/scores (\code{huber} or \code{tukey}).}

\item{diagnosis}{Should the function returns diagnostic plots and results? Default is FALSE}

\item{se.method}{How should the standard error be estimated? Either by sandwich variance formula (default and recommended) or the bootstrap.}

\item{k}{Threshold parameter in the Huber and Tukey loss functions.}

\item{B}{Number of bootstrap resamples}

\item{suppress.warning}{Should warning messages be suppressed?}

\item{initialization}{Method to initialize the robust estimator. "Mode" is not supported currently.}

\item{niter}{Maximum number of interations to solve the estimating equations.}

\item{tol}{Numerical precision.}
}
\value{
A list
\describe{
\item{beta.hat}{Estimated causal effect}
\item{beta.se}{Standard error of \code{beta.hat}}
\item{beta.p.value}{Two-sided p-value of \code{beta.hat}}
\item{tau2.hat}{Overdispersion parameter if \code{over.dispersion = TRUE}}
\item{tau2.se}{Standard error of \code{tau2.hat}}
\item{std.resid}{Standardized residuals of each SNP, returned if \code{diagnosis = TRUE}}
\item{beta.hat.loo}{Leave-one-out estimates of \code{beta.hat}, returned if \code{diagnosis = TRUE}}
\item{beta.hat.bootstrap}{Median of the bootstrap estimates, returned if \code{se.method = "bootstrap"}}
\item{beta.se.bootstrap}{Median absolute deviation of the bootstrap estimates, returned if \code{se.method = "bootstrap"}}
}
}
\description{
\code{mr.raps} is the main function.

\code{mr.raps.all}: Quick analysis with all six methods

\code{mr.raps.simple}: No overdispersion, l2 loss

\code{mr.raps.overdispersed}: Overdispersion, l2 loss

\code{mr.raps.simple.robust}: No overdispersion, robust loss

\code{mr.raps.overdispersed.robust}: Overdispersed, robust loss
}
\section{Functions}{
\itemize{
\item \code{mr.raps.all}: 

\item \code{mr.raps.simple}: 

\item \code{mr.raps.overdispersed}: 

\item \code{mr.raps.simple.robust}: 

\item \code{mr.raps.overdispersed.robust}: 
}}

\examples{

data(bmi.sbp)
attach(bmi.sbp)

## All estimators
mr.raps.all(beta.exposure, beta.outcome, se.exposure, se.outcome)

## Diagnostic plots
res <- mr.raps(beta.exposure, beta.outcome, se.exposure, se.outcome,
diagnosis = TRUE)
res <- mr.raps(beta.exposure, beta.outcome, se.exposure, se.outcome,
TRUE, diagnosis = TRUE)
res <- mr.raps(beta.exposure, beta.outcome, se.exposure, se.outcome,
TRUE, "tukey", diagnosis = TRUE)

detach(bmi.sbp)

data(bmi.bmi)
attach(bmi.bmi)

## Because both the exposure and the outcome are BMI, the true "causal" effect should be 1.

## All estimators
mr.raps.all(beta.exposure, beta.outcome, se.exposure, se.outcome)

detach(bmi.bmi)

}
\references{
Qingyuan Zhao, Jingshu Wang, Jack Bowden, Dylan S. Small. Statistical inference in two-sample summary-data Mendelian randomization using robust adjusted profile score. \url{https://arxiv.org/abs/1801.09652}.
}
