% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{atnv}
\alias{atnv}
\title{A function replacing negative values.}
\usage{
atnv(NMRdata = NULL, noiseLevels = NULL)
}
\arguments{
\item{NMRdata}{A matrix containing NMR data. Columns=frequencies,rows=samples}

\item{noiseLevels}{A vector}
}
\value{
NMRdata An invisible matrix containing NMR data without negative values.
}
\description{
This function replaces (column-wise) negative values by a small positive
number. The number is calculated as an affine transformation to the range of
the lowest positive number to 0,01*the lowest positive number (of this
column). Ranks stay unchanged. Positive numbers are not altered.
If sample-wise noise levels are available, the median noise level of samples
with negative values is calculated and replaces the lowest positive number in
case it is smaller. If no noise data is available, the 1% percentile of all
positive values in the data set is used as an estimate.
It is recommended to us this function AFTER noise removal and other data
clean-up methods, as it may alter (reduce) the noise level.
If no NMR data and noise levels are provided as arguments, the function will
use NMR data and noise levels from the global variables mrbin.env$bins and
mrbin.env$mrbinTMP.
}
\examples{
 Example<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.005,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,7.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,
                   NMRfolders=c(system.file("extdata/2/10/pdata/10",package="mrbin"),
                              system.file("extdata/3/10/pdata/10",package="mrbin"))
                   ))
 sum(Example$bins<=0)
 exampleNMRpositive<-atnv(NMRdata=Example$bins, noiseLevels=Example$parameters$noise_level)
 sum(exampleNMRpositive<=0)
}
