% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFT_matrix.R
\name{dftMatrix}
\alias{dftMatrix}
\title{Create a n-by-n discrete Fourier transform matrix.}
\usage{
dftMatrix(n)
}
\arguments{
\item{n}{Dimension for the DFT matrix.}
}
\value{
The n-by-n DFT matrix.
}
\description{
The discrete Fourier transform (DFT) matrix for a given dimension n is
calculated.
}
\details{
The DFT matrix can be used for computing the discrete Fourier transform of 
a matrix or vector. \code{dftMatrix(n) \%*\% testMatrix} is the same as
\code{apply(testMatrix, MARGIN = 2, FUN = fft)}.
}
\examples{
set.seed(987)
testMatrix <- matrix(sample(1:10, size = 25, replace = TRUE), nrow = 5)
D <- dftMatrix(5)

# Discrete Fourier transform with matrix multiplication:
D \%*\% testMatrix 

# Discrete Fourier transform with function fft: 
apply(testMatrix, MARGIN = 2, FUN = fft)

}
