% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpmrf2d.R
\name{cpmrf2d}
\alias{cpmrf2d}
\alias{cp_mrf2d}
\title{Conditional probabilities in a pixel position}
\usage{
cp_mrf2d(Z, mrfi, theta, pos)
}
\arguments{
\item{Z}{A \code{matrix} with integers in \verb{\{0,...,C\}}.}

\item{mrfi}{A \code{\link[=mrfi-class]{mrfi}} object representing the
interaction structure.}

\item{theta}{A 3-dimensional array describing potentials. Slices represent
interacting positions, rows represent pixel values and columns represent
neighbor values. As an example: \code{theta[1,3,2]} has the potential pairs of
values 0,2 in the second relative position of \code{mrfi}.}

\item{pos}{Length-2 vector with the position to compute conditional
probabilities in.}
}
\value{
A \code{numeric} vector with the conditional probabilities.
}
\description{
Computes the vector of conditional probabilities
for a pixel position given a field, an interaction structure and
a parameter array.
}
\examples{
cp_mrf2d(Z_potts, mrfi(1), theta_potts, c(57,31))
cp_mrf2d(Z_potts, mrfi(1), theta_potts*0.1, c(57,31))

}
\seealso{
A paper with detailed description of the package can be found at
\url{https://arxiv.org/abs/2006.00383}
}
\author{
Victor Freguglia
}
