% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{pkmodel}
\alias{pkmodel}
\title{Simulate from 1- or 2-compartment PK model.}
\usage{
pkmodel(ncmt = 1, depot = FALSE, ...)
}
\arguments{
\item{ncmt}{passed to \code{\link{PKMODEL}}}

\item{depot}{passed to \code{\link{PKMODEL}}}

\item{...}{passed to \code{\link{update}}}
}
\value{
An object of class \code{\link{mrgmod-class}}
}
\description{
This is an R function that returns model objects based on \code{$PKMODEL}.
}
\details{
Once the model object is generated, use \code{\link{param}} to check names of the parameters in the model and \code{\link{init}} to check
the names of the compartments in the model.  Calculations for the amounts in each compartment are done via analytical solutions, not differential equations.
A subject-level random effect is also provided for each PK parameter; use \code{\link{omat}} to see the names of those random effects.  All random effect
variances have initial value of zero and may be updated via \code{\link{omat}}.
}
\examples{

mod <- pkmodel(1)

mod \%>\% ev(amt=1000, ii=24, addl=3) \%>\% mrgsim(end=120)

\dontrun{
mod <- pkmodel(1,TRUE)
mod <- pkmodel(2)
mod <- pkmodel(2,TRUE)
}




}
