% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msasnet.R
\name{msasnet}
\alias{msasnet}
\title{Multi-Step Adaptive SCAD-Net}
\usage{
msasnet(x, y, family = c("gaussian", "binomial", "poisson", "cox"),
  init = c("snet", "ridge"), nsteps = 2L, nfolds = 5L, gammas = c(2.01,
  2.3, 3.7, 200), alphas = seq(0.05, 0.95, 0.05), eps = 1e-04,
  max.iter = 10000L, gamma = 1, seed = 1001, parallel = FALSE,
  verbose = FALSE)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response vector if \code{family} is \code{"gaussian"},
\code{"binomial"} or \code{"poisson"}.
If \code{family} is \code{"cox"}, a response matrix made by
\code{\link[survival]{Surv}}.}

\item{family}{Model family, can be \code{"gaussian"},
\code{"binomial"}, \code{"poisson"}, or \code{"cox"}.}

\item{init}{Type of the penalty used in the initial
estimation step. Can be \code{"snet"} or \code{"ridge"}.}

\item{nsteps}{How many adaptive estimation steps? At least 2.
We assume adaptive SCAD-net has only 1 adaptive estimation step.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{gammas}{Vector of candidate \code{gamma}s to use in SCAD-Net.}

\item{alphas}{Vector of candidate \code{alpha}s to use in SCAD-Net.}

\item{eps}{Convergence threshhold to use in SCAD-net.}

\item{max.iter}{Maximum number of iterations to use in SCAD-net.}

\item{gamma}{Scaling factor for adaptive weights:
\code{weights = coefs^(-gamma)}.}

\item{seed}{Two random seeds for cross-validation fold division
in two estimation steps.}

\item{parallel}{Logical. Enable parallel parameter tuning or not,
default is {FALSE}. To enable parallel tuning, load the
\code{doParallel} package and run \code{registerDoParallel()}
with the number of CPU cores before calling this function.}

\item{verbose}{Should we print out the estimation progress?}
}
\value{
List of coefficients \code{beta} and
\code{ncvreg} model object \code{model}.
}
\description{
Multi-Step Adaptive SCAD-Net
}
\examples{
dat = msaenet.sim.gaussian(n = 150, p = 500, rho = 0.6,
                           coef = rep(1, 5), snr = 2, p.train = 0.7,
                           seed = 1001)

msasnet.fit = msasnet(dat$x.tr, dat$y.tr,
                      gammas = 3.7, alphas = seq(0.3, 0.9, 0.3),
                      nsteps = 3L, seed = 1003)

print(msasnet.fit)
msaenet.nzv(msasnet.fit)
msaenet.fp(msasnet.fit, 1:5)
msaenet.tp(msasnet.fit, 1:5)
msasnet.pred = predict(msasnet.fit, dat$x.te)
msaenet.rmse(dat$y.te, msasnet.pred)
plot(msasnet.fit)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}

