% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculate_entropy_similarity}
\alias{calculate_entropy_similarity}
\title{Entropy similarity between two spectra}
\usage{
calculate_entropy_similarity(
  peaks_a,
  peaks_b,
  ms2_tolerance_in_da,
  ms2_tolerance_in_ppm,
  clean_spectra,
  min_mz,
  max_mz,
  noise_threshold,
  max_peak_num
)
}
\arguments{
\item{peaks_a}{A matrix of spectral peaks, with two columns: mz and intensity}

\item{peaks_b}{A matrix of spectral peaks, with two columns: mz and intensity}

\item{ms2_tolerance_in_da}{The MS2 tolerance in Da, set to -1 to disable}

\item{ms2_tolerance_in_ppm}{The MS2 tolerance in ppm, set to -1 to disable}

\item{clean_spectra}{Whether to clean the spectra before calculating the entropy similarity, see \code{\link{clean_spectrum}}}

\item{min_mz}{The minimum mz value to keep, set to -1 to disable}

\item{max_mz}{The maximum mz value to keep, set to -1 to disable}

\item{noise_threshold}{The noise threshold, set to -1 to disable, all peaks have intensity < noise_threshold * max_intensity will be removed}

\item{max_peak_num}{The maximum number of peaks to keep, set to -1 to disable}
}
\value{
The entropy similarity
}
\description{
Calculate the entropy similarity between two spectra
}
\examples{
mz_a <- c(169.071, 186.066, 186.0769)
intensity_a <- c(7.917962, 1.021589, 100.0)
mz_b <- c(120.212, 169.071, 186.066)
intensity_b <- c(37.16, 66.83, 999.0)
peaks_a <- matrix(c(mz_a, intensity_a), ncol = 2, byrow = FALSE)
peaks_b <- matrix(c(mz_b, intensity_b), ncol = 2, byrow = FALSE)
calculate_entropy_similarity(peaks_a, peaks_b,
                             ms2_tolerance_in_da = 0.02, ms2_tolerance_in_ppm = -1,
                             clean_spectra = TRUE, min_mz = 0, max_mz = 1000,
                             noise_threshold = 0.01,
                             max_peak_num = 100)

}
