\name{print.msgl}
\alias{print.msgl}
\title{Print function for msgl}
\usage{
  \method{print}{msgl} (x, ...)
}
\arguments{
  \item{x}{msgl object}

  \item{...}{ignored}
}
\description{
  This funtion will print some general information about
  the msgl object
}
\examples{
data(SimData)
x <- sim.data$x
classes <- sim.data$classes

### Estimation
lambda <- msgl.lambda.seq(x, classes, alpha = .5, d = 50, lambda.min = 0.05)
fit <- msgl(x, classes, alpha = .5, lambda = lambda)

# Print some information about the estimated models
fit

### Cross validation
fit.cv <- msgl.cv(x, classes, alpha = .5, lambda = lambda)

# Print some information
fit.cv

### Subsampling
test <- list(1:20, 21:40)
train <- lapply(test, function(s) (1:length(classes))[-s])

lambda <- msgl.lambda.seq(x, classes, alpha = .5, d = 50, lambda.min = 0.05)
fit.sub <- msgl.subsampling(x, classes, alpha = .5, lambda = lambda, training = train, test = test)

# Print some information
fit.sub
}
\author{
  Martin Vincent
}

