% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mssm.R
\name{mssm-Laplace}
\alias{mssm-Laplace}
\title{Parameter Estimation with Laplace Approximation for Multivariate
State Space Model}
\arguments{
\item{cfix}{starting values for coefficient for the fixed effects.}

\item{disp}{starting value for additional parameters for the family
(e.g., a dispersion parameter).}

\item{F.}{starting values for matrix in the transition density of the state
vector.}

\item{Q}{starting values for covariance matrix in the transition density
of the state vector.}

\item{Q0}{un-used.}

\item{mu0}{un-used.}

\item{trace}{integer controlling whether information should be printed
during parameter estimation. Zero yields no information.}
}
\value{
An object of class \code{mssmLaplace} with the following elements
\item{F.}{estimate of \code{F.}.}
\item{Q}{estimate of \code{Q}.}
\item{cfix}{estimate of \code{cfix}.}
\item{logLik}{approximate log-likelihood at estimates.}
\item{n_it}{number of Laplace approximations.}
\item{code}{returned code from \code{nlopt}.}
\item{disp}{estimated dispersion parameter.}

Remaining elements are the same as returned by \code{\link{mssm}}.
}
\description{
Function returned from \code{\link{mssm}} which can be used to perform
parameter estimation with a Laplace approximation.
}
\examples{
if(require(Ecdat)){
  # load data and fit glm to get starting values
  data("Gasoline", package = "Ecdat")
  glm_fit <- glm(lgaspcar ~ factor(country) + lincomep + lrpmg + lcarpcap,
                 Gamma("log"), Gasoline)

  # get object to perform estimation
  library(mssm)
  ll_func <- mssm(
    fixed = formula(glm_fit), random = ~ 1, family = Gamma("log"),
    data = Gasoline, ti = year, control = mssm_control(
      N_part = 1000L, n_threads = 1L))

  # fit model with time-varying intercept with Laplace approximation
  disp <- summary(glm_fit)$dispersion
  laplace <- ll_func$Laplace(
    cfix = coef(glm_fit), disp = disp, F. = diag(.5, 1), Q = diag(1))
  print(laplace)
}
}
\seealso{
\code{\link{mssm}}.
}
