% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microstrategy.R
\name{connect_mstr}
\alias{connect_mstr}
\title{Create a MicroStrategy REST API connection}
\usage{
connect_mstr(base_url, username, password, project_name = NULL,
  project_id = NULL, login_mode = 1, ssl_verify = TRUE)
}
\arguments{
\item{base_url}{URL of the MicroStrategy REST API server}

\item{username}{Username}

\item{password}{Password}

\item{project_name}{Name of the project you intend to connect to. Case-sensitive}

\item{project_id}{ID of the project you intend to connect to}

\item{login_mode}{Specifies the authentication mode to use. Supported authentication modes
are Standard (1) (default) or LDAP (16)}

\item{ssl_verify}{If \code{TRUE} (default), verifies the server's SSL certificates with each request}
}
\value{
A connection object to use in subsequent requests
}
\description{
Establishes and creates a connection with the MicroStrategy REST API.
}
\examples{
\donttest{
# Connect to a MicroStrategy environment
con <- connect_mstr(base_url = "https://demo.microstrategy.com/MicroStrategyLibrary/api",
                    username = "user",
                    password = "password",
                    project_name = "Financial Reporting")

# A good practice is to disconnect once you're done
# In case you forget, the server will disconnect the session after some time has passed
close(con)
}
}
