% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\docType{class}
\name{Connection}
\alias{Connection}
\title{Connect to the MicroStrategy environment.}
\description{
Allows to establish, renew, check status and close the connection with MicroStrategy Intelligence Server.
}
\examples{
\dontrun{
# Create a connection object.
connection = Connection$new(base_url, username, password, project_name)

# Connect or renew connection.
connection$connect()

# Check connection status.
connection$status()

# Renew connection to reset timeout counter.
connection$renew()

# Close connection.
connection$close()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{base_url}}{URL of the MicroStrategy REST API server.}

\item{\code{username}}{Your username.}

\item{\code{password}}{Your password.}

\item{\code{project_name}}{Name of the connected MicroStrategy Project. One of project name or project id is necessary.}

\item{\code{project_id}}{ID of the connected MicroStrategy Project. One of project name or project id is necessary.}

\item{\code{login_mode}}{Specifies authentication mode to use. Standard = 1 (default) or LDAP = 16.}

\item{\code{ssl_verify}}{If True (default), verifies the server's SSL certificates with each request.}

\item{\code{web_version}}{The current web version}

\item{\code{iserver_version}}{The current I-Server version}

\item{\code{auth_token}}{The authentication token returned by the I-Server}

\item{\code{cookies}}{Cookies}

\item{\code{identity_token}}{Identity token for delegated session. Used for connection initialized by GUI.}

\item{\code{verbose}}{If True (default), displays additional messages.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Connection$new()}}
\item \href{#method-connect}{\code{Connection$connect()}}
\item \href{#method-delegate}{\code{Connection$delegate()}}
\item \href{#method-get_identity_token}{\code{Connection$get_identity_token()}}
\item \href{#method-close}{\code{Connection$close()}}
\item \href{#method-renew}{\code{Connection$renew()}}
\item \href{#method-status}{\code{Connection$status()}}
\item \href{#method-clone}{\code{Connection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Establishes new connection with MicroStrategy Intelligence Server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$new(
  base_url,
  username = NULL,
  password = NULL,
  project_name = NULL,
  project_id = NULL,
  login_mode = 1,
  ssl_verify = TRUE,
  proxies = NULL,
  identity_token = NULL,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_url}}{URL of the MicroStrategy REST API server.}

\item{\code{username}}{Your username.}

\item{\code{password}}{Your password.}

\item{\code{project_name}}{Name of the connected MicroStrategy Project. One of project name or project id is necessary.}

\item{\code{project_id}}{ID of the connected MicroStrategy Project. One of project name or project id is necessary.}

\item{\code{login_mode}}{Specifies authentication mode to use. Standard = 1 (default) or LDAP = 16.}

\item{\code{ssl_verify}}{If True (default), verifies the server's SSL certificates with each request.}

\item{\code{proxies}}{If NULL (default) proxy is not defined. To set proxy use formula: (<username>:<password>@)<ip_address>:<port> ()-optional}

\item{\code{identity_token}}{Identity token for delegated session. Used for connection initialized by GUI.}

\item{\code{verbose}}{If True, displays additional messages. FALSE by default.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new "Connection" object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-connect"></a>}}
\if{latex}{\out{\hypertarget{method-connect}{}}}
\subsection{Method \code{connect()}}{
Establishes new connection with MicroStrategy Intelligence Server, or renews active connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$connect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delegate"></a>}}
\if{latex}{\out{\hypertarget{method-delegate}{}}}
\subsection{Method \code{delegate()}}{
Delegates identity token to get authentication token and connect to MicroStrategy Intelligence Server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$delegate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_identity_token"></a>}}
\if{latex}{\out{\hypertarget{method-get_identity_token}{}}}
\subsection{Method \code{get_identity_token()}}{
Gets identity token using existing authentication token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$get_identity_token()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-close"></a>}}
\if{latex}{\out{\hypertarget{method-close}{}}}
\subsection{Method \code{close()}}{
Closes a connection with MicroStrategy REST API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-renew"></a>}}
\if{latex}{\out{\hypertarget{method-renew}{}}}
\subsection{Method \code{renew()}}{
Renews connection with MicroStrategy REST API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$renew()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-status"></a>}}
\if{latex}{\out{\hypertarget{method-status}{}}}
\subsection{Method \code{status()}}{
Displays status of the connection with MicroStrategy REST API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$status()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
