% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename.datasets}
\alias{rename.cols.mudata}
\alias{rename.datasets}
\alias{rename.locations}
\alias{rename.params}
\title{Rename datasets, params, locations, and columns}
\usage{
rename.datasets(md, ..., apply_to = c("data", "locations", "params",
  "datasets", "columns"), warn_missing = TRUE)

rename.params(md, ..., apply_to = c("data", "params"), warn_missing = TRUE)

rename.locations(md, ..., apply_to = c("data", "locations"),
  warn_missing = TRUE)

\method{rename.cols}{mudata}(.data, ..., apply_to = c("datasets", "locations",
  "params", "data", "columns"), warn_missing = FALSE,
  warn_duplicated = TRUE)
}
\arguments{
\item{md}{A \link{mudata} object}

\item{...}{Key/value pairs in the form \code{"oldvalue"="newvalue"}}

\item{apply_to}{The tables which the rename operation should consider}

\item{warn_missing}{Print a message if any old names are not actually present}

\item{.data}{A \link{mudata} object}

\item{warn_duplicated}{Print a message if any name appears more than once in x 
after the operation.}
}
\value{
A modified \link{mudata} object.
}
\description{
Provides a convenient way to rename datasets, params, locations, and columns
such that their usage with a mudata object remains consistent.
}
\examples{
data(kentvillegreenwood)
md2 <- rename.datasets(kentvillegreenwood, ecclimate="avalley")
validate.mudata(md2)
md2 <- rename.locations(kentvillegreenwood, "GREENWOOD A"="Greenwood")
validate.mudata(md2)
md2 <- rename.params(kentvillegreenwood, maxtemp="Maximum Temperature")
validate.mudata(md2)
md2 <- rename.cols(kentvillegreenwood, latitude="lat", longitude="lon")
validate.mudata(md2)

}

